/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hansken.extraction.plugin.grpc.RpcTransformerRequest;
import org.hansken.extraction.plugin.grpc.RpcTransformerResponse;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.TransformerArgument;
import org.hansken.plugin.extraction.api.TransformerLabel;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ExtractionPluginClientTest {
    private static TransformerArgument invokeTransformer(String type, String argument) {
        Object parsedArgument = ExtractionPluginClient.createTransformerArgument((String)type, (String)argument);
        RpcTransformerResponse response = RpcTransformerResponse.newBuilder().setResponse(Pack.transformerArgument((Object)parsedArgument)).build();
        ExtractionPluginClient client = (ExtractionPluginClient)Mockito.spy((Object)new ExtractionPluginClient("localhost", 12345));
        ((ExtractionPluginClient)Mockito.doReturn((Object)response).when((Object)client)).invokeTransformer((RpcTransformerRequest)ArgumentMatchers.any(RpcTransformerRequest.class));
        Map<String, String> parameters = Map.of("value", type);
        TransformerLabel label = new TransformerLabel("my_transformer", parameters, type);
        Map<String, String> namedArguments = Map.of("value", argument);
        TransformerArgument returnValue = client.transform(label, namedArguments);
        ((ExtractionPluginClient)Mockito.verify((Object)client)).transform(label, namedArguments);
        ((ExtractionPluginClient)Mockito.verify((Object)client)).invokeTransformer((RpcTransformerRequest)ArgumentMatchers.any(RpcTransformerRequest.class));
        return returnValue;
    }

    @Test
    public void testBooleanTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("boolean", "true").getArgument();
        Assertions.assertInstanceOf(Boolean.class, (Object)response);
        Assertions.assertEquals((Object)true, (Object)response, (String)String.format("Expected: true, but was %s", response));
    }

    @Test
    public void testBinaryTransformer() throws UnsupportedEncodingException {
        byte[] originalValue = Base64.getDecoder().decode("ABCDEF==".getBytes(StandardCharsets.UTF_8));
        Object response = ExtractionPluginClientTest.invokeTransformer("binary", "\"ABCDEF==\"").getArgument();
        Assertions.assertInstanceOf(byte[].class, (Object)response);
        Assertions.assertArrayEquals((byte[])originalValue, (byte[])((byte[])response), (String)"Binary data after deserialization not equal to input data");
    }

    @Test
    public void testLongTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("integer", "123456789").getArgument();
        Assertions.assertInstanceOf(Long.class, (Object)response);
        Assertions.assertEquals((Object)123456789L, (Object)response, (String)String.format("Expected: 123456789, but was %s", response));
    }

    @Test
    public void testDoubleTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("real", "1.2345").getArgument();
        Assertions.assertInstanceOf(Double.class, (Object)response);
        Assertions.assertEquals((Object)1.2345, (Object)response, (String)String.format("Expected: 1.2345, but was %s", response));
    }

    @Test
    public void testStringTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("string", "\"exampleValue\"").getArgument();
        Assertions.assertInstanceOf(String.class, (Object)response);
        Assertions.assertEquals((Object)"exampleValue", (Object)response, (String)String.format("Expected: exampleValue, but was %s", response));
    }

    @Test
    public void testDateTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("date", "\"2025-01-01T12:34:56Z\"").getArgument();
        Assertions.assertInstanceOf(ZonedDateTime.class, (Object)response);
        ZonedDateTime expectedDateTime = ZonedDateTime.of(2025, 1, 1, 12, 34, 56, 0, ZoneId.of("UTC"));
        Assertions.assertEquals((Object)expectedDateTime, (Object)response, (String)String.format("Expected: 2025-01-01T12:34:56Z, but was %s", response));
    }

    @Test
    public void testLatLongTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("latLong", "\"+52.044777+4.358557\"").getArgument();
        Assertions.assertInstanceOf(LatLong.class, (Object)response);
        Assertions.assertEquals((Object)LatLong.of((double)52.044777, (double)4.358557), (Object)response, (String)"LatLong after deserialization not equal to input LatLong");
    }

    @Test
    public void testVectorTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("vector", "\"ABCDEF==\"").getArgument();
        Assertions.assertInstanceOf(Vector.class, (Object)response);
        Assertions.assertEquals((Object)Vector.ofBase64((String)"ABCDEF=="), (Object)response, (String)"Vector after deserialization not equal to input vector");
    }

    @Test
    public void testListTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("list", "[\"value1\",\"value2\"]").getArgument();
        Assertions.assertInstanceOf(List.class, (Object)response);
        Assertions.assertEquals(List.of("value1", "value2"), (Object)response, (String)String.format("Expected: [\"value1\",\"value2\"], but was %s", response));
    }

    @Test
    public void testMapTransformer() {
        Object response = ExtractionPluginClientTest.invokeTransformer("map", "{\"key1\": \"value1\", \"key2\":\"value2\"}").getArgument();
        Assertions.assertInstanceOf(Map.class, (Object)response);
        Assertions.assertEquals(Map.of("key1", "value1", "key2", "value2"), (Object)response, (String)String.format("Expected: {\"key1\":\"value1\",\"key2\":\"value2\"}, but was %s", response));
    }

    @Test
    public void testInvalidTransformerArgumentType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TransformerArgument(new HashSet()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TransformerArgument((Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TransformerArgument((Object)Float.valueOf(1.1234f)));
    }
}

