/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginGrpcAdapter;
import org.hansken.plugin.extraction.runtime.grpc.client.ProtocolHandler;
import org.hansken.plugin.extraction.runtime.grpc.client.ReplyStream;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.mockito.Mockito;

public class TestExtractionPluginClient
extends ExtractionPluginClient {
    private final ExtractionPluginGrpcAdapter _adapter;

    public TestExtractionPluginClient(String host, int port, ExtractionPluginGrpcAdapter adapter) {
        super(host, port);
        this._adapter = adapter;
    }

    protected ExtractionPluginGrpcAdapter adapter(ClientTrace trace, ClientDataContext context, TraceSearcher searcher) {
        return this._adapter;
    }

    public static ExtractionPluginClient withHandler(String host, int port, final ProtocolHandlerCreator handler) {
        return new ExtractionPluginClient(host, port){

            protected ProtocolHandler handler(ClientTrace trace, ClientDataContext context, TraceSearcher searcher, ReplyStream stream) {
                try {
                    return handler.create(trace, context, stream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static ProtocolHandlerCreator createHandler() {
        return (trace, context, stream) -> {
            ExtractionPluginGrpcAdapter adapter = (ExtractionPluginGrpcAdapter)Mockito.spy((Object)new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context)));
            ProtocolHandler handler = (ProtocolHandler)Mockito.spy((Object)new ProtocolHandler(stream, adapter));
            return handler;
        };
    }

    public static interface ProtocolHandlerCreator {
        public ProtocolHandler create(ClientTrace var1, ClientDataContext var2, ReplyStream var3) throws ExecutionException, IOException, InterruptedException;
    }
}

