package org.hansken.plugin.extraction.runtime.grpc.client;

import static grpc.health.v1.HealthGrpc.newBlockingStub;
import static io.grpc.ManagedChannelBuilder.forTarget;

import grpc.health.v1.HealthGrpc.HealthBlockingStub;

/**
 * Health service utilities.
 *
 * @author Netherlands Forensic Institute
 */
public final class HealthUtil {

    private HealthUtil() {
      // Util class
    }

    /**
     * Get a {@link HealthBlockingStub}. Note that this method is used in the test-framework because using the code
     * directly gives problems with shading.
     *
     * @param target a host and port combined into an authority string
     * @return a blocking stub for the health service
     */
    public static HealthBlockingStub getHealthBlockingStub(final String target) {
        return newBlockingStub(forTarget(target)
            .usePlaintext()
            .build());
    }
}
