package org.hansken.plugin.extraction.runtime.grpc.client;

import com.google.protobuf.Any;

import io.grpc.stub.StreamObserver;

/**
 * A helper class to be used to send messages to the server. This helper class is required
 * because we have to send replies to server requests, which is not supported out of the box by gRPC.
 */
public final class ReplyStream {

    private StreamObserver<Any> _other;

    /**
     * Create a replier which communicates on a given {@link StreamObserver stream}.
     *
     * @param other the stream to communicate on
     */
    public void init(final StreamObserver<Any> other) {
        _other = other;
    }

    /**
     * Send a message over the stream.
     *
     * @param message the message to send
     * @see StreamObserver#onNext(Object)
     */
    public void reply(final Any message) {
        _other.onNext(message);
    }

    /**
     * Signal normal completion of the stream.
     *
     * @see StreamObserver#onCompleted()
     */
    public void onCompleted() {
        _other.onCompleted();
    }

    /**
     * Signal erroneous completion of the stream.
     *
     * @param t the error cause
     * @see StreamObserver#onError(Throwable)
     */
    public void onError(final Throwable t) {
        _other.onError(t);
    }
}
