/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcProfile;
import org.hansken.plugin.extraction.runtime.grpc.client.PluginRunProfile;
import org.junit.jupiter.api.Test;

public class PluginRunProfileTest {
    @Test
    void createFromRpcMessage() {
        RpcProfile emptyProfileRpc = RpcProfile.newBuilder().build();
        PluginRunProfile emptyProfile = PluginRunProfile.of((RpcProfile)emptyProfileRpc);
        MatcherAssert.assertThat((Object)emptyProfile.getIntegers().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)emptyProfile.getDoubles().size(), (Matcher)Matchers.is((Object)0));
        RpcProfile singleIntProfileRpc = RpcProfile.newBuilder().putProfileInt64S("foo", 91L).build();
        PluginRunProfile singleIntProfile = PluginRunProfile.of((RpcProfile)singleIntProfileRpc);
        MatcherAssert.assertThat((Object)singleIntProfile.getIntegers().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Long)singleIntProfile.getIntegers().get("foo")), (Matcher)Matchers.is((Object)91L));
        MatcherAssert.assertThat((Object)singleIntProfile.getDoubles().size(), (Matcher)Matchers.is((Object)0));
        RpcProfile singleDoubleProfileRpc = RpcProfile.newBuilder().putProfileDoubles("foo", 91.9).build();
        PluginRunProfile singleDoubleProfile = PluginRunProfile.of((RpcProfile)singleDoubleProfileRpc);
        MatcherAssert.assertThat((Object)singleDoubleProfile.getIntegers().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)singleDoubleProfile.getDoubles().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Double)singleDoubleProfile.getDoubles().get("foo")), (Matcher)Matchers.is((Object)91.9));
        RpcProfile multiProfileRpc = RpcProfile.newBuilder().putProfileInt64S("foo", 91L).putProfileInt64S("bar", 92L).putProfileDoubles("baz", 91.9).putProfileDoubles("foobarbaz", 92.9).build();
        PluginRunProfile multiProfile = PluginRunProfile.of((RpcProfile)multiProfileRpc);
        MatcherAssert.assertThat((Object)multiProfile.getIntegers().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)multiProfile.getDoubles().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Long)multiProfile.getIntegers().get("foo")), (Matcher)Matchers.is((Object)91L));
        MatcherAssert.assertThat((Object)((Long)multiProfile.getIntegers().get("bar")), (Matcher)Matchers.is((Object)92L));
        MatcherAssert.assertThat((Object)((Double)multiProfile.getDoubles().get("baz")), (Matcher)Matchers.is((Object)91.9));
        MatcherAssert.assertThat((Object)((Double)multiProfile.getDoubles().get("foobarbaz")), (Matcher)Matchers.is((Object)92.9));
    }
}

