/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hansken.extraction.plugin.grpc.RpcAuthor;
import org.hansken.extraction.plugin.grpc.RpcBytes;
import org.hansken.extraction.plugin.grpc.RpcDataContext;
import org.hansken.extraction.plugin.grpc.RpcMaturity;
import org.hansken.extraction.plugin.grpc.RpcPluginIdentifier;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.extraction.plugin.grpc.RpcPluginResources;
import org.hansken.extraction.plugin.grpc.RpcPluginType;
import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTraceProperty;
import org.hansken.plugin.extraction.api.Author;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.MaturityLevel;
import org.hansken.plugin.extraction.api.PluginId;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.PluginResources;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

final class PackingAssertions {
    private PackingAssertions() {
    }

    static void assertEqualValues(RpcPluginInfo rpcInfo, PluginInfo info) {
        Assertions.assertAll((Executable[])new Executable[]{() -> PackingAssertions.assertOptionalEquals(rpcInfo.getName(), info.name()), () -> Assertions.assertEquals((Object)rpcInfo.getVersion(), (Object)info.pluginVersion()), () -> Assertions.assertEquals((Object)rpcInfo.getDescription(), (Object)info.description()), () -> PackingAssertions.assertEqualValues(rpcInfo.getAuthor(), info.author()), () -> PackingAssertions.assertEqualValues(rpcInfo.getMaturity(), info.maturityLevel()), () -> Assertions.assertEquals((Object)rpcInfo.getMatcher(), (Object)info.hqlMatcher()), () -> Assertions.assertEquals((Object)rpcInfo.getWebpageUrl(), (Object)info.webpageUrl()), () -> Assertions.assertEquals((int)rpcInfo.getDeferredIterations(), (int)info.deferredIterations()), () -> PackingAssertions.assertOptionalEquals(rpcInfo.getId(), info.id()), () -> PackingAssertions.assertOptionalEquals(rpcInfo.getLicense(), info.license()), () -> PackingAssertions.assertEqualValues(rpcInfo.getResources(), info.resources())});
    }

    static void assertOptionalEquals(String rpcValue, String value) {
        if (!Strings.isNullOrEmpty((String)rpcValue) || !Strings.isNullOrEmpty((String)value)) {
            Assertions.assertEquals((Object)rpcValue, (Object)value);
        }
    }

    static void assertEqualValues(RpcAuthor rpcAuthor, Author author) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)rpcAuthor.getName(), (Object)author.name()), () -> Assertions.assertEquals((Object)rpcAuthor.getEmail(), (Object)author.email()), () -> Assertions.assertEquals((Object)rpcAuthor.getOrganisation(), (Object)author.organisation())});
    }

    static void assertEqualValues(RpcMaturity rpcMaturity, MaturityLevel maturity) {
        Assertions.assertEquals((Object)PackingAssertions.normalise(rpcMaturity.name()), (Object)PackingAssertions.normalise(maturity.name()));
    }

    static void assertEqualValues(RpcPluginType rpcType, PluginType type) {
        Assertions.assertEquals((Object)PackingAssertions.normalise(rpcType.name()), (Object)PackingAssertions.normalise(type.name()));
    }

    static void assertEqualValues(RpcPluginResources rpcPluginResources, PluginResources pluginResources) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((float)rpcPluginResources.getMaxCpu(), (Float)pluginResources.maximumCpu()), () -> Assertions.assertEquals((int)rpcPluginResources.getMaxMemory(), (Integer)pluginResources.maximumMemory())});
    }

    public static void assertEqualValues(RpcTrace rpcTrace, Trace trace) {
        HashSet rpcTypes = new HashSet(rpcTrace.getTypesList());
        Set rpcProperties = rpcTrace.getPropertiesList().stream().map(RpcTraceProperty::getName).collect(Collectors.toSet());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)rpcTypes, (Object)trace.types()), () -> Assertions.assertEquals((Object)rpcProperties, (Object)trace.properties()), () -> rpcTrace.getPropertiesList().forEach(property -> {
            if (property.getValue().is(RpcBytes.class)) {
                Assertions.assertArrayEquals((byte[])((byte[])Unpack.primitive((Any)property.getValue())), (byte[])((byte[])trace.get(property.getName())));
            } else {
                Assertions.assertEquals((Object)Unpack.primitive((Any)property.getValue()), (Object)trace.get(property.getName()));
            }
        })});
    }

    static void assertEqualValues(RpcPluginIdentifier rpcId, PluginId id) {
        Assertions.assertEquals((Object)PackingAssertions.normalise(rpcId.getDomain()), (Object)PackingAssertions.normalise(id.domain()));
        Assertions.assertEquals((Object)PackingAssertions.normalise(rpcId.getCategory()), (Object)PackingAssertions.normalise(id.category()));
        Assertions.assertEquals((Object)PackingAssertions.normalise(rpcId.getName()), (Object)PackingAssertions.normalise(id.name()));
    }

    static void assertOptionalEquals(RpcPluginIdentifier rpcId, PluginId id) {
        if (id == null) {
            Assertions.assertNotNull((Object)rpcId);
            Assertions.assertTrue((boolean)rpcId.getDomain().isEmpty());
            Assertions.assertTrue((boolean)rpcId.getCategory().isEmpty());
            Assertions.assertTrue((boolean)rpcId.getName().isEmpty());
            Assertions.assertNull((Object)id);
        } else {
            PackingAssertions.assertEqualValues(rpcId, id);
        }
    }

    static void assertEqualMetadata(RpcDataContext rpcContext, DataContext context) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)rpcContext.getDataType(), (Object)context.dataType()), () -> PackingAssertions.assertEqualMetadata(rpcContext.getData(), context.data())});
    }

    static void assertEqualMetadata(RpcRandomAccessDataMeta rpcData, RandomAccessData data) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)rpcData.getSize(), (long)data.size()), () -> Assertions.assertEquals((Object)rpcData.getFirstBytes(), (Object)ByteString.copyFrom((byte[])data.readNBytes(0x100000)))});
    }

    private static String normalise(String maturity) {
        return maturity.replaceAll("_", "").toLowerCase();
    }
}

