/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcAuthor;
import org.hansken.extraction.plugin.grpc.RpcBoolean;
import org.hansken.extraction.plugin.grpc.RpcBytes;
import org.hansken.extraction.plugin.grpc.RpcDouble;
import org.hansken.extraction.plugin.grpc.RpcDoubleList;
import org.hansken.extraction.plugin.grpc.RpcEmptyList;
import org.hansken.extraction.plugin.grpc.RpcEmptyMap;
import org.hansken.extraction.plugin.grpc.RpcInteger;
import org.hansken.extraction.plugin.grpc.RpcLong;
import org.hansken.extraction.plugin.grpc.RpcLongList;
import org.hansken.extraction.plugin.grpc.RpcMap;
import org.hansken.extraction.plugin.grpc.RpcMaturity;
import org.hansken.extraction.plugin.grpc.RpcNull;
import org.hansken.extraction.plugin.grpc.RpcPluginIdentifier;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.extraction.plugin.grpc.RpcPluginResources;
import org.hansken.extraction.plugin.grpc.RpcPluginType;
import org.hansken.extraction.plugin.grpc.RpcRange;
import org.hansken.extraction.plugin.grpc.RpcRangedTransformation;
import org.hansken.extraction.plugin.grpc.RpcSearchScope;
import org.hansken.extraction.plugin.grpc.RpcString;
import org.hansken.extraction.plugin.grpc.RpcStringList;
import org.hansken.extraction.plugin.grpc.RpcStringMap;
import org.hansken.extraction.plugin.grpc.RpcTraceProperty;
import org.hansken.extraction.plugin.grpc.RpcTracelet;
import org.hansken.extraction.plugin.grpc.RpcTransformation;
import org.hansken.extraction.plugin.grpc.RpcUnixTime;
import org.hansken.extraction.plugin.grpc.RpcVector;
import org.hansken.extraction.plugin.grpc.RpcZonedDateTime;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.PackingAssertions;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnpackTest {
    private static final RpcAuthor AUTHOR = RpcAuthor.newBuilder().setName("John").setEmail("johndoe@email.com").setOrganisation("Netherlands Forensic Institute").build();
    private static final RpcPluginResources PLUGIN_RESOURCES = RpcPluginResources.newBuilder().setMaxCpu(1.0f).setMaxMemory(1024).build();
    private static final RpcPluginIdentifier ID = RpcPluginIdentifier.newBuilder().setName("DigestPlugin").setCategory("category").setDomain("doma.in").build();
    private static final RpcPluginInfo INFO = RpcPluginInfo.newBuilder().setVersion("0.1.12").setDescription("Calculates hashes from data streams.").setApiVersion("1.2.3-SNAPSHOT").setAuthor(AUTHOR).setMaturity(RpcMaturity.ProductionReady).setWebpageUrl("https://www.hansken.org").setDeferredIterations(2).setId(ID).setLicense("Apache License 6.3").setResources(PLUGIN_RESOURCES).build();

    UnpackTest() {
    }

    @Test
    void unPackInfo() {
        PluginInfo unpackedInfo = Unpack.pluginInfo((RpcPluginInfo)INFO);
        PackingAssertions.assertEqualValues(INFO, unpackedInfo);
        Assertions.assertNull((Object)unpackedInfo.name());
        MatcherAssert.assertThat((Object)Unpack.pluginApiVersion((RpcPluginInfo)INFO), (Matcher)Matchers.is((Object)"1.2.3-SNAPSHOT"));
    }

    @Test
    void unPackInfoNoID() {
        RpcPluginInfo legacyInfo = RpcPluginInfo.newBuilder().setName(ID.getName()).setVersion("0.1.12").setDescription("Calculates hashes from data streams.").setApiVersion("6.6.6").setAuthor(AUTHOR).setMaturity(RpcMaturity.ProductionReady).setWebpageUrl("https://www.hansken.org").setDeferredIterations(2).setLicense("Apache License 6.3").build();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Unpack.pluginInfo((RpcPluginInfo)legacyInfo));
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"argument 'domain' cannot be empty", (Object)exception.getMessage());
    }

    @Test
    void unPackInfoLegacy() {
        RpcPluginInfo legacyInfo = RpcPluginInfo.newBuilder().setName(ID.getName()).setVersion("0.1.12").setDescription("Calculates hashes from data streams.").setApiVersion(VersionUtil.LAST_VERSION_TO_SUPPORT_PLUGIN_INFO_NAME.toString()).setAuthor(AUTHOR).setMaturity(RpcMaturity.ProductionReady).setWebpageUrl("https://www.hansken.org").setDeferredIterations(2).build();
        PluginInfo unpackedInfo = Unpack.pluginInfo((RpcPluginInfo)legacyInfo);
        PackingAssertions.assertEqualValues(legacyInfo, unpackedInfo);
        Assertions.assertNull((Object)unpackedInfo.id());
        Assertions.assertEquals((Object)ID.getName(), (Object)unpackedInfo.name());
    }

    @Test
    void unPackInfoLegacyNoName() {
        RpcPluginInfo info = RpcPluginInfo.newBuilder().setVersion("0.1.12").setDescription("Calculates hashes from data streams.").setApiVersion(VersionUtil.LAST_VERSION_TO_SUPPORT_PLUGIN_INFO_NAME.toString()).setAuthor(AUTHOR).setMaturity(RpcMaturity.ProductionReady).setWebpageUrl("https://www.hansken.org").setDeferredIterations(2).setId(ID).setLicense("Apache License 6.3").build();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Unpack.pluginInfo((RpcPluginInfo)info));
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"argument 'name' cannot be empty", (Object)exception.getMessage());
    }

    @Test
    void unPackAuthor() {
        PackingAssertions.assertEqualValues(AUTHOR, Unpack.author((RpcAuthor)AUTHOR));
    }

    @Test
    void unPackMaturity() {
        PackingAssertions.assertEqualValues(RpcMaturity.ProofOfConcept, Unpack.maturityLevel((RpcMaturity)RpcMaturity.ProofOfConcept));
        PackingAssertions.assertEqualValues(RpcMaturity.ReadyForTest, Unpack.maturityLevel((RpcMaturity)RpcMaturity.ReadyForTest));
        PackingAssertions.assertEqualValues(RpcMaturity.ProductionReady, Unpack.maturityLevel((RpcMaturity)RpcMaturity.ProductionReady));
    }

    @Test
    void unPackPluginType() {
        PackingAssertions.assertEqualValues(RpcPluginType.ExtractionPlugin, Unpack.pluginType((RpcPluginType)RpcPluginType.ExtractionPlugin));
        PackingAssertions.assertEqualValues(RpcPluginType.DeferredExtractionPlugin, Unpack.pluginType((RpcPluginType)RpcPluginType.DeferredExtractionPlugin));
        PackingAssertions.assertEqualValues(RpcPluginType.MetaExtractionPlugin, Unpack.pluginType((RpcPluginType)RpcPluginType.MetaExtractionPlugin));
    }

    @Test
    void unpackResources() {
        PackingAssertions.assertEqualValues(PLUGIN_RESOURCES, Unpack.pluginResources((RpcPluginResources)PLUGIN_RESOURCES));
    }

    @Test
    void unPackPrimitive() {
        RpcNull nullMessage = RpcNull.getDefaultInstance();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)nullMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        RpcBytes bytesMessage = RpcBytes.newBuilder().setValue(ByteString.copyFrom((byte[])"these are bytes".getBytes(StandardCharsets.UTF_8))).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)bytesMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"these are bytes".getBytes(StandardCharsets.UTF_8))));
        RpcBoolean booleanMessage = RpcBoolean.newBuilder().setValue(true).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)booleanMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        RpcInteger integerMessage = RpcInteger.newBuilder().setValue(42).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)integerMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)42)));
        RpcLong longMessage = RpcLong.newBuilder().setValue(Long.MAX_VALUE).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)longMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Long.MAX_VALUE)));
        RpcDouble doubleMessage = RpcDouble.newBuilder().setValue(Double.NEGATIVE_INFINITY).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)doubleMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Double.NEGATIVE_INFINITY)));
        RpcString stringMessage = RpcString.newBuilder().setValue("this is a string").build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)stringMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"this is a string")));
        RpcVector vectorMessage = RpcVector.newBuilder().setValue(ByteString.copyFrom((byte[])Vector.of((float[])new float[]{1.0f, 2.0f, 3.0f}).asBinary())).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)vectorMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Vector.of((float[])new float[]{1.0f, 2.0f, 3.0f}))));
        ZonedDateTime timestamp = ZonedDateTime.of(2020, 4, 11, 17, 5, 23, (int)TimeUnit.MILLISECONDS.toNanos(123L), ZoneOffset.UTC);
        RpcZonedDateTime dateTimeMessage = RpcZonedDateTime.newBuilder().setEpochSecond(timestamp.toEpochSecond()).setNanoOfSecond(timestamp.getNano()).setZoneOffset(timestamp.getOffset().getId()).setZoneId(timestamp.getZone().getId()).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)dateTimeMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)timestamp)));
        Date date = new Date(timestamp.toInstant().toEpochMilli());
        RpcUnixTime unixTimeMessage = RpcUnixTime.newBuilder().setValue(timestamp.toInstant().toEpochMilli()).build();
        ZonedDateTime unpacked = (ZonedDateTime)Unpack.primitive((Any)Any.pack((Message)unixTimeMessage));
        MatcherAssert.assertThat((Object)unpacked.toInstant().toEpochMilli(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)date.getTime())));
        RpcEmptyList emptyListMessage = RpcEmptyList.newBuilder().build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)emptyListMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(Collections.emptyList())));
        RpcStringList stringListMessage = RpcStringList.newBuilder().addAllValues(List.of("a", "b", "c")).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)stringListMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(List.of("a", "b", "c"))));
        RpcLongList longListMessage = RpcLongList.newBuilder().addAllValues(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L))).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)longListMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)))));
        RpcDoubleList doubleListMessage = RpcDoubleList.newBuilder().addAllValues(List.of(Double.valueOf(1.1), Double.valueOf(2.2), Double.valueOf(3.3))).build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)doubleListMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(List.of(Double.valueOf(1.1), Double.valueOf(2.2), Double.valueOf(3.3)))));
        RpcEmptyMap emptyMapMessage = RpcEmptyMap.newBuilder().build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)emptyMapMessage)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(Collections.emptyMap())));
        RpcStringMap stringStringMap = RpcStringMap.newBuilder().putEntries("not", "x").build();
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)stringStringMap)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(Map.of("not", "x"))));
        Map<String, List<String>> heterogeneousMap = Map.of("not", "x", "bla", 13.37, "foo", List.of("bla"));
        RpcMap map = (RpcMap)Pack.primitive(heterogeneousMap);
        MatcherAssert.assertThat((Object)Unpack.primitive((Any)Any.pack((Message)map)), (Matcher)Matchers.is((Matcher)Matchers.equalTo(heterogeneousMap)));
    }

    @Test
    void traceletProperty() {
        RpcString stringMessage = RpcString.newBuilder().setValue("idstring").build();
        RpcTracelet rpcTracelet = RpcTracelet.newBuilder().setName("collection").addAllProperties(List.of(RpcTraceProperty.newBuilder().setName("collection.id").setValue(Any.pack((Message)stringMessage)).build())).build();
        Trace.Tracelet tracelet = Unpack.tracelet((RpcTracelet)rpcTracelet);
        MatcherAssert.assertThat((Object)tracelet.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"collection")));
        MatcherAssert.assertThat((Object)tracelet.getValue().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)tracelet.getValue().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"collection.id")));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)tracelet.getValue().get(0)).getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"idstring")));
    }

    @Test
    void transformations() {
        ArrayList<RpcTransformation> rpcTransformations = new ArrayList<RpcTransformation>();
        rpcTransformations.add(this.createRpcTransformation(this.createRpcRange(1, 2), this.createRpcRange(3, 4)));
        rpcTransformations.add(this.createRpcTransformation(this.createRpcRange(5, 6)));
        List transformations = Unpack.transformations(rpcTransformations);
        Assertions.assertEquals((long)1L, (long)((DataRange)((RangedDataTransformation)transformations.get(0)).getRanges().get(0)).getOffset());
        Assertions.assertEquals((long)2L, (long)((DataRange)((RangedDataTransformation)transformations.get(0)).getRanges().get(0)).getLength());
        Assertions.assertEquals((long)3L, (long)((DataRange)((RangedDataTransformation)transformations.get(0)).getRanges().get(1)).getOffset());
        Assertions.assertEquals((long)4L, (long)((DataRange)((RangedDataTransformation)transformations.get(0)).getRanges().get(1)).getLength());
        Assertions.assertEquals((long)5L, (long)((DataRange)((RangedDataTransformation)transformations.get(1)).getRanges().get(0)).getOffset());
        Assertions.assertEquals((long)6L, (long)((DataRange)((RangedDataTransformation)transformations.get(1)).getRanges().get(0)).getLength());
    }

    @Test
    void searchScope() {
        Assertions.assertEquals((Object)Unpack.searchScope((RpcSearchScope)RpcSearchScope.Project), (Object)TraceSearcher.SearchScope.PROJECT);
        Assertions.assertEquals((Object)Unpack.searchScope((RpcSearchScope)RpcSearchScope.Image), (Object)TraceSearcher.SearchScope.IMAGE);
        Assertions.assertEquals((Object)Unpack.searchScope(null), (Object)TraceSearcher.SearchScope.PROJECT);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Unpack.searchScope((RpcSearchScope)RpcSearchScope.UNRECOGNIZED));
    }

    private RpcTransformation createRpcTransformation(RpcRange ... ranges) {
        return RpcTransformation.newBuilder().setRangedTransformation(RpcRangedTransformation.newBuilder().addAllRanges(List.of(ranges)).build()).build();
    }

    private RpcRange createRpcRange(int offset, int length) {
        return RpcRange.newBuilder().setOffset((long)offset).setLength((long)length).build();
    }
}

