package org.hansken.plugin.extraction.runtime.json;

import java.io.IOException;
import java.util.Map;

import org.hansken.plugin.extraction.api.LatLong;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class LatLongDeserializer extends JsonDeserializer<LatLong> {
    @Override
    public LatLong deserialize(final JsonParser jsonParser, final DeserializationContext deserializationContext) throws IOException {
        final Map<String, Double> values = jsonParser.readValueAs(new TypeReference<Map<String, Double>>() {
        });
        if (!values.containsKey("latitude") || !values.containsKey("longitude")) {
            throw new IOException("Parameter latitude or/and longitude not specified");
        }
        return LatLong.of(values.remove("latitude"), values.remove("longitude"));
    }
}
