package org.hansken.plugin.extraction.runtime.json;

import java.io.IOException;

import org.hansken.plugin.extraction.api.Vector;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class VectorDeserializer extends JsonDeserializer<Vector> {
    @Override
    public Vector deserialize(final JsonParser jsonParser, final DeserializationContext deserializationContext) throws IOException, JacksonException {
        final String values = jsonParser.readValueAs(new TypeReference<String>() {
        });
        return Vector.ofBase64(values);
    }
}
