package org.hansken.plugin.extraction.runtime.grpc.common;

import org.hansken.plugin.extraction.api.DataContext;

/**
 * Collection of functions for validation or conditional checking utilities.
 */
public final class Checks {

    private Checks() {
    }

    /**
     * Check if this {@link DataContext} is a {@code 'meta'} context, meaning
     * there is no associated data to read.
     *
     * @param context the context to check
     * @return {@code true} if it is such a context, otherwise {@code false}
     */
    public static boolean isMetaContext(final DataContext context) {
        return "meta".equals(context.dataType());
    }

    /**
     * Assert that the given {@code dataType} is not {@code 'meta'}, else throw an exception.
     *
     * @param dataType the data type to check
     * @throws IllegalStateException if the data type is {@code 'meta'}
     */
    public static void assertIsNotMeta(final String dataType) {
        if ("meta".equals(dataType)) {
            throw new IllegalStateException("meta context has no associated data stream");
        }
    }
}
