/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.ep.shade.com.google.protobuf.ByteString;
import org.hansken.ep.shade.com.google.protobuf.Message;
import org.hansken.ep.shade.io.grpc.Status;
import org.hansken.ep.shade.io.grpc.StatusRuntimeException;
import org.hansken.extraction.plugin.grpc.RpcAuthor;
import org.hansken.extraction.plugin.grpc.RpcBoolean;
import org.hansken.extraction.plugin.grpc.RpcBytes;
import org.hansken.extraction.plugin.grpc.RpcDataContext;
import org.hansken.extraction.plugin.grpc.RpcDataStreamTransformation;
import org.hansken.extraction.plugin.grpc.RpcDouble;
import org.hansken.extraction.plugin.grpc.RpcDoubleList;
import org.hansken.extraction.plugin.grpc.RpcEmptyList;
import org.hansken.extraction.plugin.grpc.RpcEmptyMap;
import org.hansken.extraction.plugin.grpc.RpcEnrichTrace;
import org.hansken.extraction.plugin.grpc.RpcInteger;
import org.hansken.extraction.plugin.grpc.RpcLatLong;
import org.hansken.extraction.plugin.grpc.RpcList;
import org.hansken.extraction.plugin.grpc.RpcLong;
import org.hansken.extraction.plugin.grpc.RpcLongList;
import org.hansken.extraction.plugin.grpc.RpcMap;
import org.hansken.extraction.plugin.grpc.RpcMaturity;
import org.hansken.extraction.plugin.grpc.RpcNull;
import org.hansken.extraction.plugin.grpc.RpcPluginIdentifier;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.extraction.plugin.grpc.RpcPluginResources;
import org.hansken.extraction.plugin.grpc.RpcPluginType;
import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.extraction.plugin.grpc.RpcRange;
import org.hansken.extraction.plugin.grpc.RpcRangedTransformation;
import org.hansken.extraction.plugin.grpc.RpcRead;
import org.hansken.extraction.plugin.grpc.RpcSearchRequest;
import org.hansken.extraction.plugin.grpc.RpcSearchResult;
import org.hansken.extraction.plugin.grpc.RpcSearchScope;
import org.hansken.extraction.plugin.grpc.RpcSearchTrace;
import org.hansken.extraction.plugin.grpc.RpcString;
import org.hansken.extraction.plugin.grpc.RpcStringList;
import org.hansken.extraction.plugin.grpc.RpcStringMap;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTraceProperty;
import org.hansken.extraction.plugin.grpc.RpcTracelet;
import org.hansken.extraction.plugin.grpc.RpcTransformation;
import org.hansken.extraction.plugin.grpc.RpcTransformerArgument;
import org.hansken.extraction.plugin.grpc.RpcTransformerRequest;
import org.hansken.extraction.plugin.grpc.RpcUnixTime;
import org.hansken.extraction.plugin.grpc.RpcVector;
import org.hansken.extraction.plugin.grpc.RpcZonedDateTime;
import org.hansken.plugin.extraction.api.Author;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.MaturityLevel;
import org.hansken.plugin.extraction.api.PluginId;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.PluginResources;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.TransformerArgument;
import org.hansken.plugin.extraction.api.TransformerLabel;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Checks;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pack {
    public static final int FIRST_BYTES_SIZE = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(Pack.class);
    private static final RpcNull NULL = RpcNull.getDefaultInstance();
    private static final RpcEmptyList EMPTY_LIST = RpcEmptyList.getDefaultInstance();
    private static final RpcEmptyMap EMPTY_MAP = RpcEmptyMap.getDefaultInstance();
    private static final Packer PRIMITIVE_PACKER = Packer.create().register(byte[].class, object -> RpcBytes.newBuilder().setValue(ByteString.copyFrom(object)).build()).register(Boolean.class, object -> RpcBoolean.newBuilder().setValue((boolean)object).build()).register(Integer.class, object -> RpcInteger.newBuilder().setValue((int)object).build()).register(Long.class, object -> RpcLong.newBuilder().setValue((long)object).build()).register(Double.class, object -> RpcDouble.newBuilder().setValue((double)object).build()).register(String.class, object -> RpcString.newBuilder().setValue((String)object).build()).register(List.class, Pack::list).register(Map.class, Pack::map).register(Date.class, object -> RpcUnixTime.newBuilder().setValue(object.getTime()).build()).register(LatLong.class, object -> RpcLatLong.newBuilder().setLatitude(object.latitude()).setLongitude(object.longitude()).build()).register(Vector.class, object -> RpcVector.newBuilder().setValue(ByteString.copyFrom(object.asBinary())).build()).register(ZonedDateTime.class, object -> RpcZonedDateTime.newBuilder().setEpochSecond(object.toEpochSecond()).setNanoOfSecond(object.getNano()).setZoneOffset(object.getOffset().getId()).setZoneId(object.getZone().getId()).build());

    private Pack() {
    }

    public static RpcTrace trace(String id, ImmutableTrace trace) {
        Set rpcProperties = trace.properties().stream().filter(Pack.filterAndLog(trace)).map(property -> Pack.property(property, trace.get(property))).collect(Collectors.toSet());
        return RpcTrace.newBuilder().setId(id).addAllTypes(trace.types()).addAllProperties(rpcProperties).build();
    }

    public static RpcSearchTrace searchTrace(SearchTrace trace) {
        Set rpcProperties = trace.properties().stream().filter(Pack.filterAndLog((ImmutableTrace)trace)).map(property -> Pack.property(property, trace.get(property))).collect(Collectors.toSet());
        List data = trace.getDataTypes().stream().map(dataType -> Pack.randomAccessDataMeta(dataType, (ImmutableTrace)trace)).collect(Collectors.toList());
        return RpcSearchTrace.newBuilder().setId(trace.traceId()).addAllProperties(rpcProperties).addAllData(data).addAllTypes(trace.types()).build();
    }

    private static Predicate<? super String> filterAndLog(ImmutableTrace trace) {
        return propertyKey -> {
            Object propertyValue = trace.get(propertyKey);
            if (Pack.isSupportedByPacker(propertyValue)) {
                return true;
            }
            LOG.warn("Property {} is of type {} which isn't supported by the SDK..yet!", propertyKey, (Object)propertyValue.getClass().getName());
            return false;
        };
    }

    private static boolean isSupportedByPacker(Object object) {
        return Pack.PRIMITIVE_PACKER._packers.keySet().stream().anyMatch(packerClass -> packerClass.isInstance(object));
    }

    public static RpcTraceProperty property(String name, Object value) {
        return RpcTraceProperty.newBuilder().setName(name).setValue(Any.pack(Pack.primitive(value))).build();
    }

    public static Message primitive(Object object) {
        return PRIMITIVE_PACKER.pack(object);
    }

    private static Message list(List<?> list) {
        if (list.isEmpty()) {
            return EMPTY_LIST;
        }
        if (Pack.allOfType(list, String.class)) {
            return RpcStringList.newBuilder().addAllValues(list).build();
        }
        if (Pack.allOfType(list, Integer.class)) {
            List longList = list.stream().map(v -> (long)v).collect(Collectors.toList());
            return RpcLongList.newBuilder().addAllValues(longList).build();
        }
        if (Pack.allOfType(list, Long.class)) {
            return RpcLongList.newBuilder().addAllValues(list).build();
        }
        if (Pack.allOfType(list, Float.class)) {
            List floatList = list.stream().map(v -> v.floatValue()).collect(Collectors.toList());
            return RpcDoubleList.newBuilder().addAllValues(floatList).build();
        }
        if (Pack.allOfType(list, Double.class)) {
            return RpcDoubleList.newBuilder().addAllValues(list).build();
        }
        throw new IllegalArgumentException("Only homogeneous List of type Strings, Integer, Long, Float, or Double are supported.");
    }

    private static Message map(Map<?, ?> map) {
        if (map.isEmpty()) {
            return EMPTY_MAP;
        }
        if (Pack.allOfType(map, String.class)) {
            return RpcStringMap.newBuilder().putAllEntries(map).build();
        }
        RpcMap.Builder mapBuilder = RpcMap.newBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Any primitive = Any.pack(Pack.primitive(entry.getValue()));
            mapBuilder.putEntries(entry.getKey(), primitive);
        }
        return mapBuilder.build();
    }

    private static boolean allOfType(List<?> list, Class<?> type) {
        for (Object element : list) {
            if (element == null) {
                throw new IllegalArgumentException("list must not contain a null");
            }
            if (type.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    private static boolean allOfType(Map<?, ?> map, Class<?> type) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                throw new IllegalArgumentException("map must not contain a null key or value");
            }
            if (type.isInstance(key) && type.isInstance(value)) continue;
            return false;
        }
        return true;
    }

    public static RpcDataContext metaOfDataContext(DataContext context) {
        return RpcDataContext.newBuilder().setDataType(context.dataType()).setData(Checks.isMetaContext(context) ? RpcRandomAccessDataMeta.getDefaultInstance() : Pack.metaOfData(context.dataType(), context.data())).build();
    }

    public static RpcRandomAccessDataMeta metaOfData(String dataType, RandomAccessData data) {
        RpcRandomAccessDataMeta.Builder meta = RpcRandomAccessDataMeta.newBuilder().setType(dataType).setSize(data.size());
        try {
            data.seek(0L);
            meta.setFirstBytes(ByteString.copyFrom(data.readNBytes(0x100000)));
        }
        catch (IOException e) {
            LOG.warn("Exception occurred when setting first bytes to send.", (Throwable)e);
        }
        return meta.build();
    }

    public static RpcRandomAccessDataMeta randomAccessDataMeta(String dataType, ImmutableTrace trace) {
        long size = ((Number)trace.get("data." + dataType + ".size")).longValue();
        RpcRandomAccessDataMeta.Builder meta = RpcRandomAccessDataMeta.newBuilder().setType(dataType).setSize(size);
        return meta.build();
    }

    public static RpcPluginInfo pluginInfo(PluginInfo info) {
        RpcPluginInfo.Builder builder = RpcPluginInfo.newBuilder().setApiVersion(VersionUtil.getApiVersion()).setType(Pack.pluginType(info.pluginType())).setVersion(info.pluginVersion()).setDescription(info.description()).setAuthor(Pack.author(info.author())).setMaturity(Pack.maturityLevel(info.maturityLevel())).setMatcher(info.hqlMatcher()).setWebpageUrl(info.webpageUrl()).setDeferredIterations(info.deferredIterations()).setId(Pack.pluginId(info.id())).setLicense(info.license());
        if (info.resources() != null) {
            builder.setResources(Pack.pluginResources(info.resources()));
        }
        return builder.build();
    }

    public static RpcPluginIdentifier pluginId(PluginId id) {
        return RpcPluginIdentifier.newBuilder().setDomain(id.domain()).setCategory(id.category()).setName(id.name()).build();
    }

    public static RpcAuthor author(Author author) {
        return RpcAuthor.newBuilder().setName(author.name()).setEmail(author.email()).setOrganisation(author.organisation()).build();
    }

    public static RpcMaturity maturityLevel(MaturityLevel maturity) {
        int valueCount = MaturityLevel.values().length;
        if (valueCount > RpcMaturity.values().length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "maturity level %s has a too large ordinal: %d", maturity, valueCount));
        }
        return RpcMaturity.values()[maturity.ordinal()];
    }

    public static RpcPluginType pluginType(PluginType type) {
        int valueCount = PluginType.values().length;
        if (valueCount > RpcPluginType.values().length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "plugin type %s has a too large ordinal: %d", type, valueCount));
        }
        return RpcPluginType.values()[type.ordinal()];
    }

    static RpcPluginResources pluginResources(PluginResources pluginResources) {
        RpcPluginResources.Builder builder = RpcPluginResources.newBuilder();
        Optional.ofNullable(pluginResources.maximumCpu()).ifPresent(builder::setMaxCpu);
        Optional.ofNullable(pluginResources.maximumMemory()).ifPresent(builder::setMaxMemory);
        Optional.ofNullable(pluginResources.maximumWorkers()).ifPresent(builder::setMaxWorkers);
        return builder.build();
    }

    public static RpcRead readParameters(long position, int count, String traceUid, String type) {
        return RpcRead.newBuilder().setPosition(position).setCount(count).setTraceUid(traceUid).setDataType(type).build();
    }

    public static RpcSearchRequest searchRequest(String query, int count, TraceSearcher.SearchScope scope) {
        return RpcSearchRequest.newBuilder().setCount(count).setQuery(query).setScope(scope == TraceSearcher.SearchScope.IMAGE ? RpcSearchScope.Image : RpcSearchScope.Project).build();
    }

    public static RpcList genericList(List<Object> list) {
        RpcList.Builder builder = RpcList.newBuilder();
        for (Object value : list) {
            Any primitive;
            if (value instanceof List) {
                primitive = Any.pack(Pack.genericList((List)value));
                builder.addValues(primitive);
                continue;
            }
            if (value instanceof Map) {
                primitive = Any.pack(Pack.genericMap((Map)value));
                builder.addValues(primitive);
                continue;
            }
            primitive = Any.pack(Pack.primitive(value));
            builder.addValues(primitive);
        }
        return builder.build();
    }

    public static RpcMap genericMap(Map<String, Object> map) {
        RpcMap.Builder builder = RpcMap.newBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Any primitive;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                primitive = Any.pack(Pack.genericList((List)value));
                builder.putEntries(key, primitive);
                continue;
            }
            if (value instanceof Map) {
                primitive = Any.pack(Pack.genericMap((Map)value));
                builder.putEntries(key, primitive);
                continue;
            }
            primitive = Any.pack(Pack.primitive(value));
            builder.putEntries(key, primitive);
        }
        return builder.build();
    }

    public static RpcTransformerArgument transformerArgument(Object argument) {
        if (argument instanceof List) {
            return RpcTransformerArgument.newBuilder().setList(Pack.genericList((List)argument)).build();
        }
        if (argument instanceof Map) {
            return RpcTransformerArgument.newBuilder().setMap(Pack.genericMap((Map)argument)).build();
        }
        Message message = PRIMITIVE_PACKER.pack(argument);
        RpcTransformerArgument.Builder builder = RpcTransformerArgument.newBuilder();
        if (message instanceof RpcBoolean) {
            return builder.setBoolean((RpcBoolean)message).build();
        }
        if (message instanceof RpcBytes) {
            return builder.setBytes((RpcBytes)message).build();
        }
        if (message instanceof RpcLong) {
            return builder.setInteger((RpcLong)message).build();
        }
        if (message instanceof RpcDouble) {
            return builder.setReal((RpcDouble)message).build();
        }
        if (message instanceof RpcString) {
            return builder.setString((RpcString)message).build();
        }
        if (message instanceof RpcVector) {
            return builder.setVector((RpcVector)message).build();
        }
        if (message instanceof RpcLatLong) {
            return builder.setLatLong((RpcLatLong)message).build();
        }
        if (message instanceof RpcZonedDateTime) {
            return builder.setDatetime((RpcZonedDateTime)message).build();
        }
        throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
    }

    public static Map<String, RpcTransformerArgument> transformerArgumentMap(Map<String, TransformerArgument> arguments) {
        HashMap<String, RpcTransformerArgument> map = new HashMap<String, RpcTransformerArgument>();
        for (Map.Entry<String, TransformerArgument> entry : arguments.entrySet()) {
            map.put(entry.getKey(), Pack.transformerArgument(entry.getValue().getArgument()));
        }
        return map;
    }

    public static RpcTransformerRequest transformerRequest(TransformerLabel label, Map<String, RpcTransformerArgument> arguments) {
        return RpcTransformerRequest.newBuilder().setMethodName(label.getMethodName()).putAllNamedArguments(arguments).build();
    }

    public static RpcEnrichTrace traceEnrichment(String id, Set<String> types, Map<String, Object> properties, List<Trace.Tracelet> tracelets, Map<String, List<DataTransformation>> transformations) {
        return RpcEnrichTrace.newBuilder().setTrace(Pack.trace(id, types, properties, tracelets, transformations)).build();
    }

    private static RpcTrace trace(String id, Set<String> types, Map<String, Object> properties, List<Trace.Tracelet> tracelets, Map<String, List<DataTransformation>> transformations) {
        Set rpcProperties = properties.keySet().stream().map(property -> Pack.property(property, properties.get(property))).collect(Collectors.toSet());
        return RpcTrace.newBuilder().setId(id).addAllTypes(types).addAllProperties(rpcProperties).addAllTracelets(Pack.rpcTracelets(tracelets)).addAllTransformations(Pack.dataStreamTransformations(transformations)).build();
    }

    public static RpcSearchResult searchResult(SearchResult result) {
        Iterable searchTraces = result.getTraces().map(Pack::searchTrace).collect(Collectors.toList());
        return RpcSearchResult.newBuilder().setTotalResults(result.getTotalHits()).addAllTraces(searchTraces).build();
    }

    private static List<RpcTracelet> rpcTracelets(List<Trace.Tracelet> allTracelets) {
        ArrayList<RpcTracelet> rpcAllTracelets = new ArrayList<RpcTracelet>();
        allTracelets.forEach(tracelet -> {
            Set rpcTraceProperties = tracelet.getValue().stream().map(traceletProperty -> Pack.property(traceletProperty.getName(), traceletProperty.getValue())).collect(Collectors.toSet());
            RpcTracelet rpcTracelet = RpcTracelet.newBuilder().setName(tracelet.getName()).addAllProperties(rpcTraceProperties).build();
            rpcAllTracelets.add(rpcTracelet);
        });
        return rpcAllTracelets;
    }

    public static StatusRuntimeException asStatusRuntimeException(Status.Code statusCode, Throwable t) {
        return statusCode.toStatus().withDescription(t.getClass().getCanonicalName() + ": " + t.getLocalizedMessage()).withCause(t).asRuntimeException();
    }

    static List<RpcDataStreamTransformation> dataStreamTransformations(Map<String, List<DataTransformation>> dataStreamTransformations) {
        return dataStreamTransformations.entrySet().stream().map(entry -> RpcDataStreamTransformation.newBuilder().setDataType((String)entry.getKey()).addAllTransformations(Pack.transformations((List)entry.getValue())).build()).collect(Collectors.toList());
    }

    private static List<RpcTransformation> transformations(List<DataTransformation> transformations) {
        ArrayList<RpcTransformation> rpcDataTransformations = new ArrayList<RpcTransformation>();
        for (DataTransformation transformation : transformations) {
            rpcDataTransformations.add(Pack.getRpcDataTransformation((RangedDataTransformation)transformation));
        }
        return rpcDataTransformations;
    }

    private static RpcTransformation getRpcDataTransformation(RangedDataTransformation rangedTransformation) {
        List ranges = rangedTransformation.getRanges().stream().map(Pack::getRpcRange).collect(Collectors.toList());
        RpcRangedTransformation rpcRangedDataTransformation = RpcRangedTransformation.newBuilder().addAllRanges(ranges).build();
        return RpcTransformation.newBuilder().setRangedTransformation(rpcRangedDataTransformation).build();
    }

    private static RpcRange getRpcRange(DataRange dataRange) {
        return RpcRange.newBuilder().setLength(dataRange.getLength()).setOffset(dataRange.getOffset()).build();
    }

    static final class Packer {
        private final Map<Class<?>, Function<Object, Message>> _packers = new HashMap();

        Packer() {
        }

        static Packer create() {
            return new Packer();
        }

        <T> Packer register(Class<T> objectType, Function<T, Message> packer) {
            this._packers.put(objectType, packer);
            return this;
        }

        Message pack(Object object) {
            if (object == null) {
                return NULL;
            }
            for (Map.Entry<Class<?>, Function<Object, Message>> packer : this._packers.entrySet()) {
                if (!packer.getKey().isInstance(object)) continue;
                return packer.getValue().apply(object);
            }
            throw new IllegalArgumentException("unhandled type of object: " + String.valueOf(object.getClass()));
        }
    }
}

