package org.hansken.plugin.extraction.runtime.json;

import java.io.IOException;

import org.hansken.plugin.extraction.api.LatLong;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class LatLongDeserializer extends JsonDeserializer<LatLong> {
    @Override
    public LatLong deserialize(final JsonParser jsonParser, final DeserializationContext deserializationContext) throws IOException {
        final String value = jsonParser.readValueAs(new TypeReference<String>() {
        });
        return LatLong.of(value);
    }
}
