/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcDataContext;
import org.hansken.extraction.plugin.grpc.RpcDataStreamTransformation;
import org.hansken.extraction.plugin.grpc.RpcList;
import org.hansken.extraction.plugin.grpc.RpcMap;
import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.extraction.plugin.grpc.RpcRange;
import org.hansken.extraction.plugin.grpc.RpcSearchRequest;
import org.hansken.extraction.plugin.grpc.RpcSearchResult;
import org.hansken.extraction.plugin.grpc.RpcSearchScope;
import org.hansken.extraction.plugin.grpc.RpcSearchTrace;
import org.hansken.extraction.plugin.grpc.RpcString;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTraceProperty;
import org.hansken.extraction.plugin.grpc.RpcTransformerArgument;
import org.hansken.extraction.plugin.grpc.RpcTransformerRequest;
import org.hansken.plugin.extraction.api.Author;
import org.hansken.plugin.extraction.api.BatchSearchResult;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.MaturityLevel;
import org.hansken.plugin.extraction.api.PluginId;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.PluginResources;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.TransformerLabel;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.PackingAssertions;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class PackTest {
    private static final Author AUTHOR = Author.builder().name("John").email("johndoe@email.com").organisation("Netherlands Forensic Institute").build();
    private static final PluginResources PLUGIN_RESOURCES = PluginResources.builder().maximumCpu(1.0f).maximumMemory(1000).maximumWorkers(1).build();
    private static final PluginId ID = new PluginId("nfi.nl", "hash", "DigestPlugin");
    private static final PluginInfo INFO = PluginInfo.builderFor((PluginType)PluginType.EXTRACTION_PLUGIN).pluginVersion("0.1.12").description("Calculates hashes from data streams.").author(AUTHOR).maturityLevel(MaturityLevel.PROOF_OF_CONCEPT).hqlMatcher("*").webpageUrl("https://foo").deferredIterations(2).id(ID).license("Apache License 2.0").resources(PLUGIN_RESOURCES).build();

    PackTest() {
    }

    @Test
    void packInfo() {
        PackingAssertions.assertEqualValues(Pack.pluginInfo((PluginInfo)INFO), INFO);
        MatcherAssert.assertThat((Object)Pack.pluginInfo((PluginInfo)INFO).getApiVersion(), (Matcher)Matchers.is((Object)VersionUtil.getApiVersion()));
    }

    @Test
    void packAuthor() {
        PackingAssertions.assertEqualValues(Pack.author((Author)AUTHOR), AUTHOR);
    }

    @Test
    void packMaturity() {
        PackingAssertions.assertEqualValues(Pack.maturityLevel((MaturityLevel)MaturityLevel.PROOF_OF_CONCEPT), MaturityLevel.PROOF_OF_CONCEPT);
        PackingAssertions.assertEqualValues(Pack.maturityLevel((MaturityLevel)MaturityLevel.READY_FOR_TEST), MaturityLevel.READY_FOR_TEST);
        PackingAssertions.assertEqualValues(Pack.maturityLevel((MaturityLevel)MaturityLevel.PRODUCTION_READY), MaturityLevel.PRODUCTION_READY);
    }

    @Test
    void packPluginType() {
        PackingAssertions.assertEqualValues(Pack.pluginType((PluginType)PluginType.EXTRACTION_PLUGIN), PluginType.EXTRACTION_PLUGIN);
        PackingAssertions.assertEqualValues(Pack.pluginType((PluginType)PluginType.DEFERRED_EXTRACTION_PLUGIN), PluginType.DEFERRED_EXTRACTION_PLUGIN);
        PackingAssertions.assertEqualValues(Pack.pluginType((PluginType)PluginType.META_EXTRACTION_PLUGIN), PluginType.META_EXTRACTION_PLUGIN);
        PackingAssertions.assertEqualValues(Pack.pluginType((PluginType)PluginType.DEFERRED_META_EXTRACTION_PLUGIN), PluginType.DEFERRED_META_EXTRACTION_PLUGIN);
    }

    @Test
    void packResources() {
        PackingAssertions.assertEqualValues(Pack.pluginResources((PluginResources)PLUGIN_RESOURCES), PLUGIN_RESOURCES);
    }

    @Test
    void packTrace() {
        final ZonedDateTime dateTime = ZonedDateTime.of(2020, 4, 11, 17, 5, 23, 123456789, ZoneId.of("Europe/Amsterdam"));
        HashMap<String, Object> properties = new HashMap<String, Object>(){
            {
                this.put("bytes", "123".getBytes(StandardCharsets.UTF_8));
                this.put("boolean", true);
                this.put("integer", 15L);
                this.put("real", 0.5);
                this.put("string", "hello!");
                this.put("vector", Vector.of((float[])new float[]{1.0f, 2.0f, 3.0f}));
                this.put("date", dateTime);
                this.put("emptylist", List.of());
                this.put("stringlist", List.of("a", "b", "c"));
                this.put("emptyMap", Map.of());
                this.put("stringMap", Map.of("x", "is"));
                this.put("map", Map.of("x", "is", "y", 13.37));
                this.put("longlist", List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
                this.put("doublelist", List.of(Double.valueOf(1.1), Double.valueOf(1.2), Double.valueOf(1.3)));
                this.put("latlong", LatLong.of((double)0.123, (double)Math.PI));
            }
        };
        Trace trace = (Trace)Mockito.mock(Trace.class);
        Mockito.when((Object)trace.types()).thenReturn(Set.of("raw", "message"));
        Mockito.when((Object)trace.properties()).thenReturn(properties.keySet());
        properties.forEach((name, value) -> Mockito.when((Object)trace.get(name)).thenReturn(value));
        PackingAssertions.assertEqualValues(Pack.trace((String)"0", (ImmutableTrace)trace), trace);
    }

    @Test
    public void packTraceWithListContainingNull() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("not null");
        strings.add(null);
        Map properties = Map.of("invalid", strings);
        Trace trace = (Trace)Mockito.mock(Trace.class);
        Mockito.when((Object)trace.types()).thenReturn(Set.of());
        Mockito.when((Object)trace.properties()).thenReturn(properties.keySet());
        properties.forEach((name, value) -> Mockito.when((Object)trace.get(name)).thenReturn(value));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.trace((String)"0", (ImmutableTrace)trace));
    }

    @Test
    public void packTraceWithListOfDifferentTypes() {
        ArrayList<Object> strings = new ArrayList<Object>();
        strings.add("not null");
        strings.add(5L);
        Map properties = Map.of("invalid", strings);
        Trace trace = (Trace)Mockito.mock(Trace.class);
        Mockito.when((Object)trace.types()).thenReturn(Set.of());
        Mockito.when((Object)trace.properties()).thenReturn(properties.keySet());
        properties.forEach((name, value) -> Mockito.when((Object)trace.get(name)).thenReturn(value));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.trace((String)"0", (ImmutableTrace)trace));
    }

    @Test
    void packExtractionContextMetaData() throws IOException {
        RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
        Mockito.when((Object)data.size()).thenReturn((Object)42L);
        Mockito.when((Object)data.position()).thenReturn((Object)1L);
        Mockito.when((Object)data.readNBytes(0x100000)).thenReturn((Object)"something".getBytes(StandardCharsets.UTF_8));
        DataContext context = (DataContext)Mockito.mock(DataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"rtf");
        Mockito.when((Object)context.data()).thenReturn((Object)data);
        RpcDataContext rpcDataContext = Pack.metaOfDataContext((DataContext)context);
        PackingAssertions.assertEqualMetadata(rpcDataContext, context);
    }

    @Test
    void packRandomAccessDataMetadata() throws IOException {
        RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
        Mockito.when((Object)data.size()).thenReturn((Object)42L);
        Mockito.when((Object)data.position()).thenReturn((Object)1L);
        Mockito.when((Object)data.readNBytes(0x100000)).thenReturn((Object)"something".getBytes(StandardCharsets.UTF_8));
        PackingAssertions.assertEqualMetadata(Pack.metaOfData((String)"foo", (RandomAccessData)data), data);
    }

    @Test
    void packRandomAccessDataMetadataFromTrace() {
        Trace trace = (Trace)Mockito.mock(Trace.class);
        Mockito.when((Object)trace.get("data.foo.size")).thenReturn((Object)100);
        RpcRandomAccessDataMeta meta = Pack.randomAccessDataMeta((String)"foo", (ImmutableTrace)trace);
        Assertions.assertEquals((long)meta.getSize(), (long)100L);
        Assertions.assertEquals((Object)meta.getType(), (Object)"foo");
    }

    @Test
    void firstBytesThrowsException() throws IOException {
        RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
        Mockito.when((Object)data.readNBytes(0x100000)).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertDoesNotThrow(() -> Pack.metaOfData((String)"bar", (RandomAccessData)data));
    }

    @Test
    void packHeterogeneousLists() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.primitive(List.of(Integer.valueOf(1), Float.valueOf(1.0f))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.primitive(List.of(Float.valueOf(1.0f), Double.valueOf(1.0))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.primitive(List.of("1", Integer.valueOf(1))));
    }

    @Test
    void packThrowable() {
        StatusRuntimeException exception = Pack.asStatusRuntimeException((Status.Code)Status.Code.INVALID_ARGUMENT, (Throwable)new IllegalArgumentException("an error"));
        MatcherAssert.assertThat((Object)exception.getStatus().getCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Status.Code.INVALID_ARGUMENT)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"IllegalArgumentException"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"an error"));
    }

    @Test
    void packUnsupported() {
        String supportedPropertyKey = "supported.string";
        String supportedPropertyValue = "";
        String unsupportedPropertyKey = "unsupported";
        StringBuffer unsupportedPropertyValue = new StringBuffer();
        Trace trace = (Trace)Mockito.mock(Trace.class);
        Mockito.when((Object)trace.types()).thenReturn(Set.of("raw", "message"));
        Mockito.when((Object)trace.properties()).thenReturn(Set.of("supported.string", "unsupported"));
        Mockito.when((Object)trace.get("supported.string")).thenReturn((Object)supportedPropertyValue);
        Mockito.when((Object)trace.get("unsupported")).thenReturn((Object)unsupportedPropertyValue);
        RpcTrace packedTrace = Pack.trace((String)"0", (ImmutableTrace)trace);
        Assertions.assertEquals((int)2, (int)trace.properties().size());
        Assertions.assertEquals((int)1, (int)packedTrace.getPropertiesCount());
        RpcTraceProperty packedProperty = packedTrace.getProperties(0);
        Assertions.assertEquals((Object)"supported.string", (Object)packedProperty.getName());
        Assertions.assertTrue((boolean)packedProperty.getValue().getValue().isEmpty());
    }

    @Test
    public void packSearchRequest() {
        RpcSearchRequest packedImageScoped = Pack.searchRequest((String)"query", (int)12, (TraceSearcher.SearchScope)TraceSearcher.SearchScope.IMAGE);
        Assertions.assertEquals((Object)packedImageScoped.getQuery(), (Object)"query");
        Assertions.assertEquals((int)packedImageScoped.getCount(), (int)12);
        Assertions.assertEquals((Object)packedImageScoped.getScope(), (Object)RpcSearchScope.Image);
        RpcSearchRequest packedProjectScoped = Pack.searchRequest((String)"*", (int)99, (TraceSearcher.SearchScope)TraceSearcher.SearchScope.PROJECT);
        Assertions.assertEquals((Object)packedProjectScoped.getQuery(), (Object)"*");
        Assertions.assertEquals((int)packedProjectScoped.getCount(), (int)99);
        Assertions.assertEquals((Object)packedProjectScoped.getScope(), (Object)RpcSearchScope.Project);
    }

    @Test
    public void packGenericList() {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        Assertions.assertEquals(list, (Object)Unpack.genericList((RpcList)Pack.genericList(list)));
        list.add(Long.valueOf(12345L));
        Assertions.assertEquals(list, (Object)Unpack.genericList((RpcList)Pack.genericList(list)));
        ArrayList<Double> embeddedList = new ArrayList<Double>();
        embeddedList.add(12.345);
        list.add(embeddedList);
        Assertions.assertEquals(list, (Object)Unpack.genericList((RpcList)Pack.genericList(list)));
        list.add(new HashSet());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.genericList((List)list));
    }

    @Test
    public void packGenericMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Assertions.assertEquals(map, (Object)Unpack.genericMap((RpcMap)Pack.genericMap(map)));
        map.put("exampleKey1", Boolean.valueOf(true));
        Assertions.assertEquals(map, (Object)Unpack.genericMap((RpcMap)Pack.genericMap(map)));
        HashMap<String, Long> embeddedMap = new HashMap<String, Long>();
        embeddedMap.put("exampleKey2", 12345L);
        map.put("exampleKey3", embeddedMap);
        Assertions.assertEquals(map, (Object)Unpack.genericMap((RpcMap)Pack.genericMap(map)));
        map.put("exampleKey4", new HashSet());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Pack.genericMap((Map)map));
    }

    @Test
    public void packTransformerRequest() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("arg1", "str");
        parameters.put("arg2", "str");
        TransformerLabel label = new TransformerLabel("my_method", parameters, "vector");
        HashMap<String, RpcTransformerArgument> args = new HashMap<String, RpcTransformerArgument>();
        args.put("arg1", RpcTransformerArgument.newBuilder().setString(RpcString.newBuilder().setValue("value1").build()).build());
        args.put("arg2", RpcTransformerArgument.newBuilder().setString(RpcString.newBuilder().setValue("value2").build()).build());
        RpcTransformerRequest request = Pack.transformerRequest((TransformerLabel)label, args);
        Assertions.assertEquals((Object)request.getMethodName(), (Object)label.getMethodName());
        Assertions.assertEquals(request.getNamedArgumentsMap().keySet(), args.keySet());
    }

    @Test
    public void packSearchResult() throws IOException {
        int i;
        SearchTrace[] traces = new SearchTrace[50];
        for (i = 0; i < 50; ++i) {
            SearchTrace trace = (SearchTrace)Mockito.mock(SearchTrace.class);
            Mockito.when((Object)trace.get((String)ArgumentMatchers.any(String.class))).thenReturn((Object)String.valueOf(i));
            Mockito.when((Object)trace.traceId()).thenReturn((Object)"0");
            Mockito.when((Object)trace.types()).thenReturn(Set.of("file", "document"));
            traces[i] = trace;
        }
        for (i = 0; i < 50; ++i) {
            RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
            Mockito.when((Object)data.readNBytes(0x100000)).thenReturn((Object)"something".getBytes(StandardCharsets.UTF_8));
        }
        BatchSearchResult result = new BatchSearchResult(50L);
        result.setTraces(traces);
        RpcSearchResult packedResult = Pack.searchResult((SearchResult)result);
        Assertions.assertEquals((long)result.getTotalHits(), (long)packedResult.getTotalResults());
        List packedTraces = packedResult.getTracesList();
        MatcherAssert.assertThat((Object)packedTraces.size(), (Matcher)Matchers.is((Object)traces.length));
        Assertions.assertEquals((Object)((RpcSearchTrace)packedTraces.get(0)).getId(), (Object)traces[0].traceId());
        Assertions.assertTrue((boolean)((RpcSearchTrace)packedTraces.get(0)).getTypesList().contains((Object)"document"));
        Assertions.assertTrue((boolean)((RpcSearchTrace)packedTraces.get(0)).getTypesList().contains((Object)"file"));
        Assertions.assertEquals((Object)((RpcSearchTrace)packedTraces.get(49)).getId(), (Object)traces[49].traceId());
    }

    @Test
    public void packTransformations() {
        HashMap transformations = new HashMap();
        ArrayList<RangedDataTransformation> rangedTransformations = new ArrayList<RangedDataTransformation>();
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(1L, 2L), new DataRange(3L, 4L)}));
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(5L, 6L)}));
        transformations.put("raw", rangedTransformations);
        List rpcTransformations = Pack.dataStreamTransformations(transformations);
        Assertions.assertEquals((int)1, (int)rpcTransformations.size());
        RpcRange range1 = ((RpcDataStreamTransformation)rpcTransformations.get(0)).getTransformations(0).getRangedTransformation().getRanges(0);
        Assertions.assertEquals((long)1L, (long)range1.getOffset());
        Assertions.assertEquals((long)2L, (long)range1.getLength());
        RpcRange range2 = ((RpcDataStreamTransformation)rpcTransformations.get(0)).getTransformations(0).getRangedTransformation().getRanges(1);
        Assertions.assertEquals((long)3L, (long)range2.getOffset());
        Assertions.assertEquals((long)4L, (long)range2.getLength());
        RpcRange range3 = ((RpcDataStreamTransformation)rpcTransformations.get(0)).getTransformations(1).getRangedTransformation().getRanges(0);
        Assertions.assertEquals((long)5L, (long)range3.getOffset());
        Assertions.assertEquals((long)6L, (long)range3.getLength());
    }
}

