/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.plugin.extraction.runtime.grpc.common.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class VersionTest {
    @Test
    void testCreateVersion() {
        VersionTest.assertVersion(new Version(1, 2, 3), 1, 2, 3, "");
        VersionTest.assertVersion(new Version(1, 2, 3, "FOO"), 1, 2, 3, "FOO");
        VersionTest.assertVersion(new Version(1, 2, 3, "mario-kart"), 1, 2, 3, "mario-kart");
    }

    @Test
    void testCreateVersionFromString() {
        VersionTest.assertVersion(Version.fromString((String)"1.2.3"), 1, 2, 3, "");
        VersionTest.assertVersion(Version.fromString((String)"2.3.4-SNAPSHOT"), 2, 3, 4, "SNAPSHOT");
        VersionTest.assertVersion(Version.fromString((String)"2.3.4-FOO"), 2, 3, 4, "FOO");
        VersionTest.assertVersion(Version.fromString((String)"2.3.4+FOO"), 2, 3, 4, "FOO");
        VersionTest.assertVersion(Version.fromString((String)"2.3.4-FOO+BAR"), 2, 3, 4, "FOO+BAR");
        VersionTest.assertVersion(Version.fromString((String)"2.3.4+FOO-BAR"), 2, 3, 4, "FOO-BAR");
        VersionTest.assertVersion(Version.fromString((String)"0.0.0-mario-kart"), 0, 0, 0, "mario-kart");
        VersionTest.assertVersion(Version.fromString((String)"0.0.0-"), 0, 0, 0, "");
        VersionTest.assertVersion(Version.fromString((String)"987.65.4321"), 987, 65, 4321, "");
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1.2"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1..2"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1.2.3.4"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"x.2.3"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1.y.3"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.fromString((String)"1.2.z"));
    }

    @Test
    void testVersionCompare() {
        MatcherAssert.assertThat((Object)new Version(1, 1, 1).compareTo(new Version(1, 1, 1)), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1, "SNAPSHOT").compareTo(new Version(1, 1, 1, "SNAPSHOT")), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1).compareTo(new Version(1, 1, 2)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1).compareTo(new Version(1, 2, 1)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1).compareTo(new Version(2, 1, 1)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1, "SNAPSHOT").compareTo(new Version(1, 1, 1)), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)new Version(1, 1, 2).compareTo(new Version(1, 1, 1)), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new Version(1, 2, 1).compareTo(new Version(1, 1, 1)), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new Version(2, 1, 1).compareTo(new Version(1, 1, 1)), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new Version(1, 1, 1).compareTo(new Version(1, 1, 1, "SNAPSHOT")), (Matcher)Matchers.is((Object)0));
        Assertions.assertThrows(NullPointerException.class, () -> new Version(1, 1, 1).compareTo(null));
    }

    @Test
    void testEquals() {
        Version version = new Version(0, 2, 1);
        Assertions.assertFalse((boolean)version.equals((Object)"0.2.1"));
        Assertions.assertTrue((boolean)version.equals((Object)version));
        Assertions.assertTrue((boolean)version.equals((Object)new Version(0, 2, 1)));
        Assertions.assertFalse((boolean)version.equals((Object)new Version(0, 2, 2)));
        Assertions.assertFalse((boolean)version.equals((Object)new Version(0, 2, 0)));
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"1.2.3", (Object)new Version(1, 2, 3).toString());
        Assertions.assertEquals((Object)"1.2.3-SNAPSHOT", (Object)new Version(1, 2, 3, "SNAPSHOT").toString());
    }

    static void assertVersion(Version version, int major, int minor, int patch, String subVersion) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)major, (int)version.getMajorVersion()), () -> Assertions.assertEquals((int)minor, (int)version.getMinorVersion()), () -> Assertions.assertEquals((int)patch, (int)version.getPatchVersion()), () -> Assertions.assertEquals((Object)subVersion, (Object)version.getSubVersion())});
    }
}

