/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import org.hansken.plugin.extraction.runtime.grpc.common.Version;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionUtilTest {
    @Test
    void testReadPropertiesFile() {
        Version.fromString((String)VersionUtil.getApiVersion());
    }

    @Test
    void testInRange() {
        Version minVersion = new Version(0, 2, 1);
        Version maxVersion = new Version(0, 3, 4);
        Assertions.assertFalse((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 2, 0)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 2, 1)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 2, 2)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 3, 0)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 3, 3)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 3, 4)));
        Assertions.assertFalse((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 3, 5)));
        Assertions.assertFalse((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(1, 0, 0)));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 2, 2, "SNAPSHOT")));
        Assertions.assertTrue((boolean)VersionUtil.versionInRange((Version)minVersion, (Version)maxVersion, (Version)new Version(0, 2, 1, "SNAPSHOT")));
    }

    @Test
    void testIsCompatible() {
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"2.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.999.9999-SNAPSHOT"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.999.0+released.55.8c2636c7"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.999.0"));
        Assertions.assertTrue((boolean)VersionUtil.isCompatible((String)"0.2.1"));
        Assertions.assertTrue((boolean)VersionUtil.isCompatible((String)"0.2.1+released.100.12345678"));
        Assertions.assertTrue((boolean)VersionUtil.isCompatible((String)"0.2.0"));
        Assertions.assertTrue((boolean)VersionUtil.isCompatible((String)"0.2.0+released.55.8c2636c7"));
        Assertions.assertTrue((boolean)VersionUtil.isCompatible((String)"0.2.0-SNAPSHOT"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.1.9"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.1.0+released.55.8c2636c7"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)"0.1.8"));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible((String)""));
        Assertions.assertFalse((boolean)VersionUtil.isCompatible(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VersionUtil.isCompatible((String)"foo"));
    }

    @Test
    void testIsHigherOrEqualTo() {
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"2.0.0", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.999.9999-SNAPSHOT", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.999.0+released.55.8c2636c7", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.999.0", (String)"3.0.0"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.1", (String)"0.0.1"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.1+released.100.12345678", (String)"0.0.1"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.0", (String)"0.0.1"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.0+released.55.8c2636c7", (String)"0.0.1"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.0-SNAPSHOT", (String)"0.0.1"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.0.1", (String)"0.0.1"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.2.0-SNAPSHOT", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.1.9", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.1.0+released.55.8c2636c7", (String)"3.0.0"));
        Assertions.assertFalse((boolean)VersionUtil.isHigherOrEqualTo((String)"0.1.8", (String)"3.0.0"));
        Assertions.assertTrue((boolean)VersionUtil.isHigherOrEqualTo((String)"0.0.1-SNAPSHOT", (String)"0.0.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VersionUtil.isHigherOrEqualTo((String)"", (String)"3.0.0"));
        Assertions.assertThrows(NullPointerException.class, () -> VersionUtil.isHigherOrEqualTo(null, (String)"3.0.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VersionUtil.isHigherOrEqualTo((String)"foo", (String)"3.0.0"));
    }
}

