package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Objects;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * This <b>reserved keyword </b>matcher matches the provided {@code value} to  the current {@code datastream}.
 * <p>
 * Wildcards and fullMatch string literals are supported.
 */
class DataTypeHqlMatcher implements HqlMatcher {
    private final String _value;
    private final boolean _fullMatch;

    DataTypeHqlMatcher(final String value) {
        _value = value;
        _fullMatch = false;
    }

    DataTypeHqlMatcher(final String value, final boolean fullMatch) {
        _value = value;
        _fullMatch = fullMatch;
    }

    @Override
    public boolean match(final ImmutableTrace trace, final String dataType) {
        return HqlMatcherUtil.matchStringValuesWithWildcards(_fullMatch, _value, dataType);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DataTypeHqlMatcher that = (DataTypeHqlMatcher) o;
        return _fullMatch == that._fullMatch &&
            Objects.equals(_value, that._value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(_value, _fullMatch);
    }
}
