package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * This interface specifies the minimum required methods that a compiled Matcher node needs to run.
 * <p>
 * Before the extraction process, Hansken will query the Extraction plugin for the PluginInfo object,
 * which also exposes the HQL string provided by the plugin, which is then compiled to a {@link HqlMatcher} instance.
 * This way, the extraction process can match the traces which
 * should be sent to the ExtractionPlugin for processing, to avoid sending irrelevant data to the plugin.
 * Delegating the matching process to the ExtractionPlugin itself would cause overhead, because in that case,
 * every trace should be sent to the plugin in order to determine if it should be processed.
 */
public interface HqlMatcher {

    /**
     * This method matches the conditions defined in the query against the trace input.
     *
     * @param trace the trace to process
     * @param dataType the type of the current trace processing iteration
     * @return true if the input trace satisfies the conditions of the query
     */
    boolean match(ImmutableTrace trace, String dataType);

    /**
     * Getter for the property we would like to match.
     *
     * @return the property we would like to match against.
     */
    default String property() {
        throw new UnsupportedOperationException();
    }

    /**
     * Getter for the match full flag.
     *
     * @return the value of the flag of whether to match full(treating wildcards as string literals), untokenized string values, default false.
     */
    default boolean fullMatch() {
        return false;
    }
}
