/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Collection;
import org.hansken.plugin.extraction.hql_lite.lang.human.HqlHumanUtil;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.RegexCache;

final class HqlMatcherUtil {
    private static final RegexCache REGEX_CACHE = new RegexCache();

    private HqlMatcherUtil() {
    }

    static boolean matchStringValuesWithWildcards(String matcherValue, String traceValue) {
        if (traceValue == null) {
            return false;
        }
        String regexValue = HqlMatcherUtil.wildcardToRegex(matcherValue);
        return REGEX_CACHE.compileRegex("^" + regexValue + "$").test(traceValue);
    }

    static boolean matchStringValuesWithWildcards(String matcherValue, Collection<String> traceValues) {
        if (matcherValue == null) {
            return false;
        }
        for (String traceValue : traceValues) {
            if (!HqlMatcherUtil.matchStringValuesWithWildcards(matcherValue, traceValue)) continue;
            return true;
        }
        return false;
    }

    private static String wildcardToRegex(String str) {
        String encoded = HqlHumanUtil.swapEscapedWildcards(str);
        String regex = encoded.replace("?", ".").replace("*", ".*");
        return HqlHumanUtil.unswapEscapedWildcards(regex);
    }
}

