/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.regex.Pattern;

final class RegexCache {
    private static final Duration DEFAULT_EXPIRE_DURATION = Duration.ofDays(1L);
    private static final long DEFAULT_MAX_SIZE = 1000L;
    private final Cache<String, Pattern> _cache = Caffeine.newBuilder().expireAfterWrite(DEFAULT_EXPIRE_DURATION).maximumSize(1000L).build();

    RegexCache() {
    }

    Predicate<String> compileRegex(String regexString) {
        return ((Pattern)this._cache.get((Object)regexString, string -> Pattern.compile(string, 32))).asMatchPredicate();
    }
}

