/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcherUtil;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.TermHqlMatcher;

class TypeHqlMatcher
implements HqlMatcher {
    private final List<TermHqlMatcher> _matchers;

    TypeHqlMatcher(List<TermHqlMatcher> matchers) {
        this._matchers = Collections.unmodifiableList(matchers);
    }

    @Override
    public boolean match(ImmutableTrace trace, String dataType) {
        for (TermHqlMatcher matcher : this._matchers) {
            if (HqlMatcherUtil.matchStringValuesWithWildcards(matcher.value(), trace.types())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeHqlMatcher that = (TypeHqlMatcher)o;
        return Objects.equals(this._matchers, that._matchers);
    }

    public int hashCode() {
        return Objects.hash(this._matchers);
    }
}

