/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.List;
import java.util.Objects;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataStreamMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcherUtil;

class TermHqlMatcher
implements DataStreamMatcher,
HqlMatcher {
    private final String _property;
    private final boolean _fullMatch;
    private final String _value;

    TermHqlMatcher(String property, boolean fullMatch, String value) {
        this._property = property;
        this._fullMatch = fullMatch;
        this._value = value;
    }

    @Override
    public boolean match(ImmutableTrace trace, String dataType) {
        return this.matchDataStream(trace, this._property);
    }

    @Override
    public boolean matchDataStream(ImmutableTrace trace, String traceDataProperty) {
        Object traceValue = trace.get(traceDataProperty);
        return this.matchOnType(traceValue);
    }

    private boolean matchOnType(Object traceValue) {
        if (traceValue == null) {
            return false;
        }
        if (traceValue instanceof String) {
            return HqlMatcherUtil.matchStringValuesWithWildcards(this._value, (String)traceValue);
        }
        if (traceValue instanceof Long) {
            return HqlMatcherUtil.matchStringValuesWithWildcards(this._value, traceValue.toString());
        }
        if (traceValue instanceof List) {
            for (Object element : (List)traceValue) {
                if (!this.matchOnType(element)) continue;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException("Unsupported type:" + traceValue.getClass());
    }

    @Override
    public final String property() {
        return this._property;
    }

    public String value() {
        return this._value;
    }

    @Override
    public boolean fullMatch() {
        return this._fullMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermHqlMatcher termQuery = (TermHqlMatcher)o;
        return this._fullMatch == termQuery._fullMatch && Objects.equals(this._property, termQuery._property) && Objects.equals(this._value, termQuery._value);
    }

    public int hashCode() {
        return Objects.hash(this._property, this._fullMatch, this._value);
    }
}

