package org.hansken.plugin.extraction.hql_lite.lang;

/**
 * ParseException, thrown when an invalid query is parsed.
 *
 * @author Netherlands Forensic Institute
 */
public class ParseException extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private final int _line;
    private final int _position;

    public ParseException(final String parser, final String message, final int line, final int position) {
        super(parser + ": line " + line + ":" + position + " " + message);
        _line = line;
        _position = position;
    }

    public int getLine() {
        return _line;
    }

    public int getPosition() {
        return _position;
    }
}
