package org.hansken.plugin.extraction.hql_lite.lang.human;

/**
 * Hql specific string utilities.
 *
 * @author Netherlands Forensic Institute
 */
public final class HqlStringUtil {

    private HqlStringUtil() {
    }

    /**
     * Removes surrounding double quotes from a string.
     *
     * @param text text to remove quotes from
     * @param quote the quote character to remove
     * @return text with quotes removed
     */
    static String unquote(final String text, final char quote) {
        int first = 0;
        if (first < text.length() && text.charAt(first) == quote) {
            first++;
        }
        int last = text.length();
        if (last > first && text.charAt(last - 1) == quote) {
            last--;
        }

        return text.substring(first, last);
    }

    /**
     * Removes surrounding double quotes from a string.
     *
     * @param text text to remove quotes from
     * @return text with quotes removed
     */
    public static String unquote(final String text) {
        return unquote(text, '"');
    }

    /**
     * Removes surrounding single quotes from a string.
     *
     * @param text text to remove quotes from
     * @return text with quotes removed
     */
    public static String unquoteSingle(final String text) {
        return unquote(text, '\'');
    }
}
