package org.hansken.plugin.extraction.hql_lite.lang.human;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.hansken.plugin.extraction.hql_lite.lang.ParseException;

/**
 * Throws a ParserException on parse errors.
 *
 * @author Netherlands Forensic Institute
 */
public class ParserErrorListener extends BaseErrorListener {

    private final Class<?> _queryParserClass;

    /**
     * Public constructor.
     *
     * @param queryParserClass parser (class name used in message)
     */
    public ParserErrorListener(final Class<?> queryParserClass) {
        _queryParserClass = queryParserClass;
    }

    @Override
    public void syntaxError(final Recognizer<?, ?> arg0, final Object arg1, final int line, final int position, final String message, final RecognitionException arg5) {
        throw new ParseException(_queryParserClass.getSimpleName(), message, line, position);
    }
}
