package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Objects;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * This <b>reserved keyword </b>matcher matches the provided {@code property/value kv pair} to  the current
 * {@code datastream} variant of said property.
 * <p>
 * Example: if the query is {@code $data.length > 0} then the matcher will attempt to match this to the current
 * {@code datastream}. so if the current {@code datastream} is {@code raw}, then the query becomes
 * {@code $data.raw.length > 0}. if {@code datastream} is {@code text} query is {@code $data.text.length > 0}...etc.
 * <p>
 * Wildcards and fullMatch string literals are supported.
 * NumberRange queries are also supported
 */
class DataHqlMatcher implements HqlMatcher {
    private final DataStreamMatcher _matcher;
    private final String _property;

    DataHqlMatcher(final HqlMatcher matcher) {
        if (matcher instanceof DataStreamMatcher) {
            _matcher = (DataStreamMatcher) matcher;
            _property = matcher.property();
        }
        else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean match(final ImmutableTrace trace, final String dataType) {
        final String data = data(dataType, _property);
        return _matcher.matchDataStream(trace, data);
    }

    private static String data(final String dataType, final String postfix) {
        return "data." + dataType + "." + postfix;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DataHqlMatcher that = (DataHqlMatcher) o;
        return Objects.equals(_matcher, that._matcher) &&
            Objects.equals(_property, that._property);
    }

    @Override
    public int hashCode() {
        return Objects.hash(_matcher, _property);
    }
}
