package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * This interface is gives DataStream matchers the functionality to match on data that is only available during runtime.
 */
interface DataStreamMatcher {

    /**
     * This method is the same as {@link HqlMatcher#match(ImmutableTrace, String)}, except that it allows the matcher to match on
     * information that would only be available during runtime.
     *
     * @param trace the trace to process
     * @param traceDataProperty the runtime based name of the property key of this trace. example:
     *     {@code property=field.size, runtime dataType=data, traceDataProperty=field.data.size}, meaning that this method
     *     will look up {@code field.data.size} with {@link ImmutableTrace#get(java.lang.String)}.
     * @return true if the input trace satisfies the conditions of the query
     */
    boolean matchDataStream(ImmutableTrace trace, String traceDataProperty);
}
