package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Objects;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * Negates the matched result of the (sub)query.
 */
class NotHqlMatcher implements HqlMatcher {
    private final HqlMatcher _matcher;

    NotHqlMatcher(final HqlMatcher matcher) {
        _matcher = matcher;
    }

    @Override
    public boolean match(final ImmutableTrace trace, final String dataType) {
        return !_matcher.match(trace, dataType);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final NotHqlMatcher notQuery = (NotHqlMatcher) o;
        return Objects.equals(_matcher, notQuery._matcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(_matcher);
    }
}
