package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * This <b>reserved keyword </b>matcher matches all of the provided {@code types} to {@link ImmutableTrace#types()}.
 * Wildcards and fullMatch string literals are supported.
 */
class TypeHqlMatcher implements HqlMatcher {
    private final List<TermHqlMatcher> _matchers;

    TypeHqlMatcher(final List<TermHqlMatcher> matchers) {
        _matchers = Collections.unmodifiableList(matchers);
    }

    @Override
    public boolean match(final ImmutableTrace trace, final String dataType) {
        for (TermHqlMatcher matcher : _matchers) {
            if (!HqlMatcherUtil.matchStringValuesWithWildcards(matcher.value(), trace.types())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final TypeHqlMatcher that = (TypeHqlMatcher) o;
        return Objects.equals(_matchers, that._matchers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(_matchers);
    }
}
