package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Arrays;

import org.hansken.plugin.extraction.api.ImmutableTrace;

/**
 * Matches ALL subQueries.
 */
class AndHqlMatcher implements HqlMatcher {
    private final HqlMatcher[] _subQueries;

    AndHqlMatcher(final HqlMatcher... queries) {
        _subQueries = queries;
    }

    @Override
    public boolean match(final ImmutableTrace trace, final String dataType) {
        for (HqlMatcher matcher : _subQueries) {
            if (!matcher.match(trace, dataType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final AndHqlMatcher andQuery = (AndHqlMatcher) o;
        return Arrays.equals(_subQueries, andQuery._subQueries);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_subQueries);
    }
}
