/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.hansken.plugin.extraction.hql_lite.lang.human.HqlHumanUtil;
import org.hansken.plugin.extraction.hql_lite.lang.human.HqlStringUtil;
import org.hansken.plugin.extraction.hql_lite.lang.human.ParserErrorListener;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataTypeHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.NumberRangeHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.QueryBuilders;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.TermHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.TypeHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.parsers.hqlhuman.HqlHumanLexer;
import org.hansken.plugin.extraction.hql_lite.lang.parsers.hqlhuman.HqlHumanParser;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;

public final class HqlLiteHumanQueryParser {
    private static final String[] TEXT_FIELDS = new String[]{"text"};
    private static final String[] META_FIELDS = new String[]{"meta"};

    private HqlLiteHumanQueryParser() {
    }

    public static HqlMatcher parse(String query, String sdkVersion) {
        return VersionUtil.isHigherOrEqualTo((String)sdkVersion, (String)"0.7.0") ? HqlLiteHumanQueryParser.parseJson(query) : HqlLiteHumanQueryParser.parse(query);
    }

    private static HqlMatcher parseJson(String query) {
        String placatedQuery = HqlHumanUtil.swapEscapedWildcards(query);
        String unescapedJson = StringEscapeUtils.unescapeJson((String)placatedQuery);
        String escapedJson = StringEscapeUtils.escapeJson((String)unescapedJson);
        String finalQuery = HqlHumanUtil.unswapEscapedWildcards(escapedJson);
        return HqlLiteHumanQueryParser.parse(finalQuery);
    }

    static HqlMatcher parse(String query) {
        HqlHumanParser parser = HqlLiteHumanQueryParser.getParser(query);
        HqlHumanParser.QueryContext context = parser.query();
        HqlMatcher matcherObj = HqlLiteHumanQueryParser.visit(context);
        return matcherObj;
    }

    private static HqlHumanParser getParser(String query) {
        ParserErrorListener listener = new ParserErrorListener(HqlLiteHumanQueryParser.class);
        HqlHumanLexer lexer = new HqlHumanLexer((CharStream)CharStreams.fromString((String)query));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HqlHumanParser parser = new HqlHumanParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return parser;
    }

    private static HqlMatcher visit(HqlHumanParser.QueryContext ctx) {
        return HqlLiteHumanQueryParser.visit(ctx.complexExpr());
    }

    private static HqlMatcher visit(HqlHumanParser.ComplexExprContext ctx) {
        if (ctx == null) {
            return QueryBuilders.all();
        }
        if (ctx.and() != null) {
            return QueryBuilders.and(HqlLiteHumanQueryParser.visit(ctx.complexExpr(0)), HqlLiteHumanQueryParser.visit(ctx.complexExpr(1)));
        }
        if (ctx.or() != null) {
            return QueryBuilders.or(HqlLiteHumanQueryParser.visit(ctx.complexExpr(0)), HqlLiteHumanQueryParser.visit(ctx.complexExpr(1)));
        }
        if (ctx.not() != null) {
            return QueryBuilders.not(HqlLiteHumanQueryParser.visit(ctx.complexExpr(0)));
        }
        if (ctx.termExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.termExpr());
        }
        if (ctx.rangeExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.rangeExpr());
        }
        if (ctx.regexExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.regexExpr());
        }
        if (ctx.phraseExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.phraseExpr());
        }
        if (ctx.hasTraceExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.hasTraceExpr());
        }
        if (ctx.hasTraceletExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.hasTraceletExpr());
        }
        if (ctx.nestedExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.nestedExpr());
        }
        if (ctx.dataTypeExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.dataTypeExpr());
        }
        if (ctx.typeExpr() != null) {
            return HqlLiteHumanQueryParser.visit(ctx.typeExpr());
        }
        List<HqlHumanParser.ComplexExprContext> complexExprs = ctx.complexExpr();
        switch (complexExprs.size()) {
            case 1: {
                return HqlLiteHumanQueryParser.visit(complexExprs.get(0));
            }
            case 2: {
                return QueryBuilders.and(HqlLiteHumanQueryParser.visit(complexExprs.get(0)), HqlLiteHumanQueryParser.visit(complexExprs.get(1)));
            }
        }
        throw new IllegalStateException("unexpected number of complex exprs: " + complexExprs.size());
    }

    private static HqlMatcher visit(HqlHumanParser.TermExprContext ctx) {
        boolean fullMatch = HqlLiteHumanQueryParser.isFullMatch(ctx.stringValue());
        boolean isDataStream = HqlLiteHumanQueryParser.isDataStream(ctx.dataFields());
        HqlHumanParser.FieldsContext fieldsCtx = isDataStream ? ctx.dataFields().fields() : ctx.fields();
        String[] fields = HqlLiteHumanQueryParser.fields(fieldsCtx, fullMatch);
        HqlHumanParser.StringValueContext valueContext = ctx.stringValue();
        String value = HqlHumanUtil.unescapeKeepWildcards(HqlLiteHumanQueryParser.visit(valueContext));
        TermHqlMatcher query = QueryBuilders.term(value, fullMatch, fields);
        HqlMatcher hqlMatcher = ctx.NEQ() == null ? query : QueryBuilders.not(query);
        return isDataStream ? QueryBuilders.data(hqlMatcher) : hqlMatcher;
    }

    private static HqlMatcher visit(HqlHumanParser.DataTypeExprContext ctx) {
        HqlHumanParser.StringValueContext stringValue = ctx.stringValue();
        boolean fullMatch = HqlLiteHumanQueryParser.isFullMatch(stringValue);
        String value = HqlHumanUtil.unescapeKeepWildcards(HqlLiteHumanQueryParser.visit(stringValue));
        DataTypeHqlMatcher query = QueryBuilders.dataType(value, fullMatch);
        return ctx.NEQ() == null ? query : QueryBuilders.not(query);
    }

    private static HqlMatcher visit(HqlHumanParser.TypeExprContext ctx) {
        HqlHumanParser.StringValueContext stringValue = ctx.stringValue();
        List<HqlHumanParser.StringValueContext> stringValueContexts = HqlLiteHumanQueryParser.flattenBinaryTreeList(stringValue);
        ArrayList<HqlMatcher> subQueries = new ArrayList<HqlMatcher>(stringValueContexts.size());
        for (HqlHumanParser.StringValueContext valueContext : stringValueContexts) {
            boolean fullMatch = HqlLiteHumanQueryParser.isFullMatch(valueContext);
            String value = HqlHumanUtil.unescapeKeepWildcards(HqlLiteHumanQueryParser.visit(valueContext));
            TermHqlMatcher term = QueryBuilders.term(value, fullMatch, "type");
            subQueries.add(term);
        }
        TypeHqlMatcher query = QueryBuilders.type(subQueries);
        return ctx.NEQ() == null ? query : QueryBuilders.not(query);
    }

    private static List<HqlHumanParser.StringValueContext> flattenBinaryTreeList(HqlHumanParser.StringValueContext stringValue) {
        ArrayList<HqlHumanParser.StringValueContext> theList = new ArrayList<HqlHumanParser.StringValueContext>();
        if (stringValue.stringValue().isEmpty()) {
            theList.add(stringValue);
        } else {
            for (HqlHumanParser.StringValueContext stringValueContext : stringValue.stringValue()) {
                theList.addAll(HqlLiteHumanQueryParser.flattenBinaryTreeList(stringValueContext));
            }
        }
        return theList;
    }

    private static boolean isFullMatch(HqlHumanParser.StringValueContext stringValue) {
        if (stringValue != null) {
            String text = stringValue.getText();
            return text != null && text.length() > 0 && text.charAt(0) == '\'';
        }
        return false;
    }

    private static String visit(HqlHumanParser.StringValueContext ctx) {
        return HqlStringUtil.unquoteSingle(ctx.getText());
    }

    private static String[] fields(HqlHumanParser.FieldsContext ctx, boolean fullMatch) {
        return HqlLiteHumanQueryParser.fields(ctx, fullMatch ? META_FIELDS : TEXT_FIELDS);
    }

    private static String[] fields(HqlHumanParser.FieldsContext ctx, String[] missing) {
        return ctx == null ? missing : HqlLiteHumanQueryParser.visit(ctx);
    }

    private static String[] visit(HqlHumanParser.FieldsContext ctx) {
        String[] fields = new String[ctx.field().size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = HqlHumanUtil.unescape(HqlStringUtil.unquoteSingle(ctx.field(i).getText()));
        }
        return fields;
    }

    private static HqlMatcher visit(HqlHumanParser.RangeExprContext ctx) {
        NumberRangeHqlMatcher query;
        boolean fullMatch = HqlLiteHumanQueryParser.isFullMatch(ctx.value(0).stringValue());
        boolean isDataStream = HqlLiteHumanQueryParser.isDataStream(ctx.dataFields());
        HqlHumanParser.FieldsContext fieldsCtx = isDataStream ? ctx.dataFields().fields() : ctx.fields();
        String[] fields = HqlLiteHumanQueryParser.fields(fieldsCtx, fullMatch);
        if (ctx.TO() != null) {
            query = QueryBuilders.range(HqlLiteHumanQueryParser.value(ctx.value(0)), HqlLiteHumanQueryParser.value(ctx.value(1)), true, fullMatch, fields);
        } else if (ctx.value().size() == 2) {
            BigDecimal[] values = new BigDecimal[]{HqlLiteHumanQueryParser.value(ctx.value(0)), HqlLiteHumanQueryParser.value(ctx.value(1))};
            boolean includesMin = ctx.SMALLER(0).getText().length() == 2;
            boolean includesMax = ctx.SMALLER(1).getText().length() == 2;
            query = QueryBuilders.range(values[0], values[1], includesMin, includesMax, fullMatch, fields);
        } else {
            BigDecimal value = HqlLiteHumanQueryParser.value(ctx.value(0));
            String op = ctx.GREATER() != null ? ctx.GREATER().getText() : ctx.SMALLER(0).getText();
            boolean includesMinMax = op.length() == 2;
            query = op.charAt(0) == '>' ? QueryBuilders.range(value, null, includesMinMax, false, fullMatch, fields) : QueryBuilders.range(null, value, includesMinMax, fullMatch, fields);
        }
        return isDataStream ? QueryBuilders.data(query) : query;
    }

    private static boolean isDataStream(HqlHumanParser.DataFieldsContext fields) {
        return fields != null;
    }

    private static HqlMatcher visit(HqlHumanParser.RegexExprContext ctx) {
        throw new UnsupportedOperationException("Regex queries are not implemented yet.");
    }

    private static HqlMatcher visit(HqlHumanParser.PhraseExprContext ctx) {
        throw new UnsupportedOperationException("Phrase queries are not implemented yet.");
    }

    private static HqlMatcher visit(HqlHumanParser.HasTraceExprContext ctx) {
        throw new UnsupportedOperationException("Trace queries are not implemented yet.");
    }

    private static HqlMatcher visit(HqlHumanParser.HasTraceletExprContext ctx) {
        throw new UnsupportedOperationException("Tracelet queries are not implemented yet.");
    }

    private static HqlMatcher visit(HqlHumanParser.NestedExprContext ctx) {
        throw new UnsupportedOperationException("Nested queries are not implemented yet.");
    }

    private static BigDecimal value(HqlHumanParser.ValueContext ctx) {
        if (ctx.latlongValue() != null) {
            throw new UnsupportedOperationException("RangeQuery: LatLong range not implemented yet.");
        }
        if (ctx.stringValue() != null) {
            String unescapedString = HqlHumanUtil.unescape(HqlLiteHumanQueryParser.visit(ctx.stringValue()));
            if (NumberUtils.isCreatable((String)unescapedString)) {
                return new BigDecimal(unescapedString);
            }
            throw new UnsupportedOperationException("RangeQuery: String range not implemented yet.");
        }
        throw new IllegalStateException("no such value context: " + String.valueOf((Object)ctx));
    }
}

