/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.io.grpc.stub;

import java.util.concurrent.atomic.AtomicReference;
import org.hansken.ep.shade.com.google.common.base.Preconditions;
import org.hansken.ep.shade.com.google.errorprone.annotations.InlineMe;
import org.hansken.ep.shade.io.grpc.CallOptions;
import org.hansken.ep.shade.io.grpc.Channel;
import org.hansken.ep.shade.io.grpc.ClientCall;
import org.hansken.ep.shade.io.grpc.ClientInterceptor;
import org.hansken.ep.shade.io.grpc.ExperimentalApi;
import org.hansken.ep.shade.io.grpc.ForwardingClientCall;
import org.hansken.ep.shade.io.grpc.ForwardingClientCallListener;
import org.hansken.ep.shade.io.grpc.Metadata;
import org.hansken.ep.shade.io.grpc.MethodDescriptor;
import org.hansken.ep.shade.io.grpc.Status;
import org.hansken.ep.shade.io.grpc.stub.AbstractStub;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1789")
    @InlineMe(replacement="stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(extraHeaders))", imports={"org.hansken.ep.shade.io.grpc.stub.MetadataUtils"})
    public static <T extends AbstractStub<T>> T attachHeaders(T stub, Metadata extraHeaders) {
        return stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(extraHeaders));
    }

    public static ClientInterceptor newAttachHeadersInterceptor(Metadata extraHeaders) {
        return new HeaderAttachingClientInterceptor(extraHeaders);
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1789")
    @InlineMe(replacement="stub.withInterceptors(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture))", imports={"org.hansken.ep.shade.io.grpc.stub.MetadataUtils"})
    public static <T extends AbstractStub<T>> T captureMetadata(T stub, AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return stub.withInterceptors(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture));
    }

    public static ClientInterceptor newCaptureMetadataInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return new MetadataCapturingClientInterceptor(headersCapture, trailersCapture);
    }

    private static final class MetadataCapturingClientInterceptor
    implements ClientInterceptor {
        final AtomicReference<Metadata> headersCapture;
        final AtomicReference<Metadata> trailersCapture;

        MetadataCapturingClientInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
            this.headersCapture = Preconditions.checkNotNull(headersCapture, "headersCapture");
            this.trailersCapture = Preconditions.checkNotNull(trailersCapture, "trailersCapture");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new MetadataCapturingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class MetadataCapturingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            MetadataCapturingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                MetadataCapturingClientInterceptor.this.headersCapture.set(null);
                MetadataCapturingClientInterceptor.this.trailersCapture.set(null);
                super.start(new MetadataCapturingClientCallListener(responseListener), headers);
            }

            private final class MetadataCapturingClientCallListener
            extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
                MetadataCapturingClientCallListener(ClientCall.Listener<RespT> responseListener) {
                    super(responseListener);
                }

                @Override
                public void onHeaders(Metadata headers) {
                    MetadataCapturingClientInterceptor.this.headersCapture.set(headers);
                    super.onHeaders(headers);
                }

                @Override
                public void onClose(Status status, Metadata trailers) {
                    MetadataCapturingClientInterceptor.this.trailersCapture.set(trailers);
                    super.onClose(status, trailers);
                }
            }
        }
    }

    private static final class HeaderAttachingClientInterceptor
    implements ClientInterceptor {
        private final Metadata extraHeaders;

        HeaderAttachingClientInterceptor(Metadata extraHeaders) {
            this.extraHeaders = Preconditions.checkNotNull(extraHeaders, "extraHeaders");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new HeaderAttachingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class HeaderAttachingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.merge(HeaderAttachingClientInterceptor.this.extraHeaders);
                super.start(responseListener, headers);
            }
        }
    }
}

