/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/type/http_request.proto

package org.hansken.ep.shade.com.google.logging.type;

/**
 *
 *
 * <pre>
 * A common proto for logging HTTP requests. Only contains semantics
 * defined by the HTTP specification. Product-specific logging
 * information MUST be defined in a separate message.
 * </pre>
 *
 * Protobuf type {@code google.logging.type.HttpRequest}
 */
public final class HttpRequest extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.logging.type.HttpRequest)
    HttpRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRequest.newBuilder() to construct.
  private HttpRequest(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRequest() {
    requestMethod_ = "";
    requestUrl_ = "";
    userAgent_ = "";
    remoteIp_ = "";
    serverIp_ = "";
    referer_ = "";
    protocol_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRequest();
  }

  public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.type.HttpRequestProto
        .internal_static_google_logging_type_HttpRequest_descriptor;
  }

  @java.lang.Override
  protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.type.HttpRequestProto
        .internal_static_google_logging_type_HttpRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.hansken.ep.shade.com.google.logging.type.HttpRequest.class,
            org.hansken.ep.shade.com.google.logging.type.HttpRequest.Builder.class);
  }

  public static final int REQUEST_METHOD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestMethod_ = "";
  /**
   *
   *
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   *
   * @return The requestMethod.
   */
  @java.lang.Override
  public java.lang.String getRequestMethod() {
    java.lang.Object ref = requestMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestMethod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   *
   * @return The bytes for requestMethod.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRequestMethodBytes() {
    java.lang.Object ref = requestMethod_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestMethod_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_URL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestUrl_ = "";
  /**
   *
   *
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   *
   * @return The requestUrl.
   */
  @java.lang.Override
  public java.lang.String getRequestUrl() {
    java.lang.Object ref = requestUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   *
   * @return The bytes for requestUrl.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRequestUrlBytes() {
    java.lang.Object ref = requestUrl_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestUrl_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_SIZE_FIELD_NUMBER = 3;
  private long requestSize_ = 0L;
  /**
   *
   *
   * <pre>
   * The size of the HTTP request message in bytes, including the request
   * headers and the request body.
   * </pre>
   *
   * <code>int64 request_size = 3;</code>
   *
   * @return The requestSize.
   */
  @java.lang.Override
  public long getRequestSize() {
    return requestSize_;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * The response code indicating the status of response.
   * Examples: 200, 404.
   * </pre>
   *
   * <code>int32 status = 4;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public int getStatus() {
    return status_;
  }

  public static final int RESPONSE_SIZE_FIELD_NUMBER = 5;
  private long responseSize_ = 0L;
  /**
   *
   *
   * <pre>
   * The size of the HTTP response message sent back to the client, in bytes,
   * including the response headers and the response body.
   * </pre>
   *
   * <code>int64 response_size = 5;</code>
   *
   * @return The responseSize.
   */
  @java.lang.Override
  public long getResponseSize() {
    return responseSize_;
  }

  public static final int USER_AGENT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userAgent_ = "";
  /**
   *
   *
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
   * CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   *
   * @return The userAgent.
   */
  @java.lang.Override
  public java.lang.String getUserAgent() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userAgent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
   * CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   *
   * @return The bytes for userAgent.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getUserAgentBytes() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userAgent_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_IP_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteIp_ = "";
  /**
   *
   *
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. This field can include port information. Examples:
   * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   *
   * @return The remoteIp.
   */
  @java.lang.Override
  public java.lang.String getRemoteIp() {
    java.lang.Object ref = remoteIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. This field can include port information. Examples:
   * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   *
   * @return The bytes for remoteIp.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRemoteIpBytes() {
    java.lang.Object ref = remoteIp_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteIp_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_IP_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serverIp_ = "";
  /**
   *
   *
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to. This field can include port information. Examples:
   * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   *
   * @return The serverIp.
   */
  @java.lang.Override
  public java.lang.String getServerIp() {
    java.lang.Object ref = serverIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serverIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to. This field can include port information. Examples:
   * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   *
   * @return The bytes for serverIp.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getServerIpBytes() {
    java.lang.Object ref = serverIp_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serverIp_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object referer_ = "";
  /**
   *
   *
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field
   * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
   * </pre>
   *
   * <code>string referer = 8;</code>
   *
   * @return The referer.
   */
  @java.lang.Override
  public java.lang.String getReferer() {
    java.lang.Object ref = referer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field
   * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
   * </pre>
   *
   * <code>string referer = 8;</code>
   *
   * @return The bytes for referer.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRefererBytes() {
    java.lang.Object ref = referer_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      referer_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATENCY_FIELD_NUMBER = 14;
  private org.hansken.ep.shade.com.google.protobuf.Duration latency_;
  /**
   *
   *
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   *
   * @return Whether the latency field is set.
   */
  @java.lang.Override
  public boolean hasLatency() {
    return latency_ != null;
  }
  /**
   *
   *
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   *
   * @return The latency.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Duration getLatency() {
    return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
  }
  /**
   *
   *
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
    return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
  }

  public static final int CACHE_LOOKUP_FIELD_NUMBER = 11;
  private boolean cacheLookup_ = false;
  /**
   *
   *
   * <pre>
   * Whether or not a cache lookup was attempted.
   * </pre>
   *
   * <code>bool cache_lookup = 11;</code>
   *
   * @return The cacheLookup.
   */
  @java.lang.Override
  public boolean getCacheLookup() {
    return cacheLookup_;
  }

  public static final int CACHE_HIT_FIELD_NUMBER = 9;
  private boolean cacheHit_ = false;
  /**
   *
   *
   * <pre>
   * Whether or not an entity was served from cache
   * (with or without validation).
   * </pre>
   *
   * <code>bool cache_hit = 9;</code>
   *
   * @return The cacheHit.
   */
  @java.lang.Override
  public boolean getCacheHit() {
    return cacheHit_;
  }

  public static final int CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER = 10;
  private boolean cacheValidatedWithOriginServer_ = false;
  /**
   *
   *
   * <pre>
   * Whether or not the response was validated with the origin server before
   * being served from cache. This field is only meaningful if `cache_hit` is
   * True.
   * </pre>
   *
   * <code>bool cache_validated_with_origin_server = 10;</code>
   *
   * @return The cacheValidatedWithOriginServer.
   */
  @java.lang.Override
  public boolean getCacheValidatedWithOriginServer() {
    return cacheValidatedWithOriginServer_;
  }

  public static final int CACHE_FILL_BYTES_FIELD_NUMBER = 12;
  private long cacheFillBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of HTTP response bytes inserted into cache. Set only when a
   * cache fill was attempted.
   * </pre>
   *
   * <code>int64 cache_fill_bytes = 12;</code>
   *
   * @return The cacheFillBytes.
   */
  @java.lang.Override
  public long getCacheFillBytes() {
    return cacheFillBytes_;
  }

  public static final int PROTOCOL_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
   * </pre>
   *
   * <code>string protocol = 15;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
   * </pre>
   *
   * <code>string protocol = 15;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestMethod_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requestMethod_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestUrl_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      output.writeInt64(3, requestSize_);
    }
    if (status_ != 0) {
      output.writeInt32(4, status_);
    }
    if (responseSize_ != 0L) {
      output.writeInt64(5, responseSize_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 6, userAgent_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteIp_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 7, remoteIp_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(referer_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 8, referer_);
    }
    if (cacheHit_ != false) {
      output.writeBool(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      output.writeBool(10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      output.writeBool(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      output.writeInt64(12, cacheFillBytes_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverIp_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 13, serverIp_);
    }
    if (latency_ != null) {
      output.writeMessage(14, getLatency());
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 15, protocol_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestMethod_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requestMethod_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestUrl_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeInt64Size(3, requestSize_);
    }
    if (status_ != 0) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeInt32Size(4, status_);
    }
    if (responseSize_ != 0L) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeInt64Size(5, responseSize_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(6, userAgent_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteIp_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(7, remoteIp_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(referer_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(8, referer_);
    }
    if (cacheHit_ != false) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeBoolSize(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      size +=
          org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeBoolSize(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeInt64Size(12, cacheFillBytes_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverIp_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(13, serverIp_);
    }
    if (latency_ != null) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeMessageSize(14, getLatency());
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(15, protocol_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.type.HttpRequest)) {
      return super.equals(obj);
    }
    org.hansken.ep.shade.com.google.logging.type.HttpRequest other = (org.hansken.ep.shade.com.google.logging.type.HttpRequest) obj;

    if (!getRequestMethod().equals(other.getRequestMethod())) return false;
    if (!getRequestUrl().equals(other.getRequestUrl())) return false;
    if (getRequestSize() != other.getRequestSize()) return false;
    if (getStatus() != other.getStatus()) return false;
    if (getResponseSize() != other.getResponseSize()) return false;
    if (!getUserAgent().equals(other.getUserAgent())) return false;
    if (!getRemoteIp().equals(other.getRemoteIp())) return false;
    if (!getServerIp().equals(other.getServerIp())) return false;
    if (!getReferer().equals(other.getReferer())) return false;
    if (hasLatency() != other.hasLatency()) return false;
    if (hasLatency()) {
      if (!getLatency().equals(other.getLatency())) return false;
    }
    if (getCacheLookup() != other.getCacheLookup()) return false;
    if (getCacheHit() != other.getCacheHit()) return false;
    if (getCacheValidatedWithOriginServer() != other.getCacheValidatedWithOriginServer())
      return false;
    if (getCacheFillBytes() != other.getCacheFillBytes()) return false;
    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REQUEST_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getRequestMethod().hashCode();
    hash = (37 * hash) + REQUEST_URL_FIELD_NUMBER;
    hash = (53 * hash) + getRequestUrl().hashCode();
    hash = (37 * hash) + REQUEST_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRequestSize());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getStatus();
    hash = (37 * hash) + RESPONSE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getResponseSize());
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgent().hashCode();
    hash = (37 * hash) + REMOTE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteIp().hashCode();
    hash = (37 * hash) + SERVER_IP_FIELD_NUMBER;
    hash = (53 * hash) + getServerIp().hashCode();
    hash = (37 * hash) + REFERER_FIELD_NUMBER;
    hash = (53 * hash) + getReferer().hashCode();
    if (hasLatency()) {
      hash = (37 * hash) + LATENCY_FIELD_NUMBER;
      hash = (53 * hash) + getLatency().hashCode();
    }
    hash = (37 * hash) + CACHE_LOOKUP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCacheLookup());
    hash = (37 * hash) + CACHE_HIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCacheHit());
    hash = (37 * hash) + CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCacheValidatedWithOriginServer());
    hash = (37 * hash) + CACHE_FILL_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCacheFillBytes());
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(java.nio.ByteBuffer data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(org.hansken.ep.shade.com.google.protobuf.ByteString data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      org.hansken.ep.shade.com.google.protobuf.ByteString data,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(byte[] data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseDelimitedFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.hansken.ep.shade.com.google.logging.type.HttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A common proto for logging HTTP requests. Only contains semantics
   * defined by the HTTP specification. Product-specific logging
   * information MUST be defined in a separate message.
   * </pre>
   *
   * Protobuf type {@code google.logging.type.HttpRequest}
   */
  public static final class Builder extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.logging.type.HttpRequest)
      com.google.logging.type.HttpRequestOrBuilder {
    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.type.HttpRequestProto
          .internal_static_google_logging_type_HttpRequest_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.type.HttpRequestProto
          .internal_static_google_logging_type_HttpRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.logging.type.HttpRequest.class,
              org.hansken.ep.shade.com.google.logging.type.HttpRequest.Builder.class);
    }

    // Construct using com.google.logging.type.HttpRequest.newBuilder()
    private Builder() {}

    private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      requestMethod_ = "";
      requestUrl_ = "";
      requestSize_ = 0L;
      status_ = 0;
      responseSize_ = 0L;
      userAgent_ = "";
      remoteIp_ = "";
      serverIp_ = "";
      referer_ = "";
      latency_ = null;
      if (latencyBuilder_ != null) {
        latencyBuilder_.dispose();
        latencyBuilder_ = null;
      }
      cacheLookup_ = false;
      cacheHit_ = false;
      cacheValidatedWithOriginServer_ = false;
      cacheFillBytes_ = 0L;
      protocol_ = "";
      return this;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.type.HttpRequestProto
          .internal_static_google_logging_type_HttpRequest_descriptor;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.logging.type.HttpRequest getDefaultInstanceForType() {
      return com.google.logging.type.HttpRequest.getDefaultInstance();
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.logging.type.HttpRequest build() {
      org.hansken.ep.shade.com.google.logging.type.HttpRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.logging.type.HttpRequest buildPartial() {
      org.hansken.ep.shade.com.google.logging.type.HttpRequest result = new com.google.logging.type.HttpRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(org.hansken.ep.shade.com.google.logging.type.HttpRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.requestMethod_ = requestMethod_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestUrl_ = requestUrl_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestSize_ = requestSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.responseSize_ = responseSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userAgent_ = userAgent_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.remoteIp_ = remoteIp_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.serverIp_ = serverIp_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.referer_ = referer_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.latency_ = latencyBuilder_ == null ? latency_ : latencyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.cacheLookup_ = cacheLookup_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.cacheHit_ = cacheHit_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.cacheValidatedWithOriginServer_ = cacheValidatedWithOriginServer_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.cacheFillBytes_ = cacheFillBytes_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.protocol_ = protocol_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.type.HttpRequest) {
        return mergeFrom((org.hansken.ep.shade.com.google.logging.type.HttpRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.hansken.ep.shade.com.google.logging.type.HttpRequest other) {
      if (other == org.hansken.ep.shade.com.google.logging.type.HttpRequest.getDefaultInstance()) return this;
      if (!other.getRequestMethod().isEmpty()) {
        requestMethod_ = other.requestMethod_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRequestUrl().isEmpty()) {
        requestUrl_ = other.requestUrl_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getRequestSize() != 0L) {
        setRequestSize(other.getRequestSize());
      }
      if (other.getStatus() != 0) {
        setStatus(other.getStatus());
      }
      if (other.getResponseSize() != 0L) {
        setResponseSize(other.getResponseSize());
      }
      if (!other.getUserAgent().isEmpty()) {
        userAgent_ = other.userAgent_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getRemoteIp().isEmpty()) {
        remoteIp_ = other.remoteIp_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getServerIp().isEmpty()) {
        serverIp_ = other.serverIp_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getReferer().isEmpty()) {
        referer_ = other.referer_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasLatency()) {
        mergeLatency(other.getLatency());
      }
      if (other.getCacheLookup() != false) {
        setCacheLookup(other.getCacheLookup());
      }
      if (other.getCacheHit() != false) {
        setCacheHit(other.getCacheHit());
      }
      if (other.getCacheValidatedWithOriginServer() != false) {
        setCacheValidatedWithOriginServer(other.getCacheValidatedWithOriginServer());
      }
      if (other.getCacheFillBytes() != 0L) {
        setCacheFillBytes(other.getCacheFillBytes());
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                requestMethod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                requestUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                requestSize_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                status_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                responseSize_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                userAgent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                remoteIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                referer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 72:
              {
                cacheHit_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 72
            case 80:
              {
                cacheValidatedWithOriginServer_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 80
            case 88:
              {
                cacheLookup_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                cacheFillBytes_ = input.readInt64();
                bitField0_ |= 0x00002000;
                break;
              } // case 96
            case 106:
              {
                serverIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getLatencyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 114
            case 122:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object requestMethod_ = "";
    /**
     *
     *
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     *
     * @return The requestMethod.
     */
    public java.lang.String getRequestMethod() {
      java.lang.Object ref = requestMethod_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     *
     * @return The bytes for requestMethod.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRequestMethodBytes() {
      java.lang.Object ref = requestMethod_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestMethod_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     *
     * @param value The requestMethod to set.
     * @return This builder for chaining.
     */
    public Builder setRequestMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestMethod_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestMethod() {
      requestMethod_ = getDefaultInstance().getRequestMethod();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     *
     * @param value The bytes for requestMethod to set.
     * @return This builder for chaining.
     */
    public Builder setRequestMethodBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestMethod_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object requestUrl_ = "";
    /**
     *
     *
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     *
     * @return The requestUrl.
     */
    public java.lang.String getRequestUrl() {
      java.lang.Object ref = requestUrl_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     *
     * @return The bytes for requestUrl.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRequestUrlBytes() {
      java.lang.Object ref = requestUrl_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestUrl_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     *
     * @param value The requestUrl to set.
     * @return This builder for chaining.
     */
    public Builder setRequestUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestUrl() {
      requestUrl_ = getDefaultInstance().getRequestUrl();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     *
     * @param value The bytes for requestUrl to set.
     * @return This builder for chaining.
     */
    public Builder setRequestUrlBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestUrl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long requestSize_;
    /**
     *
     *
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     *
     * @return The requestSize.
     */
    @java.lang.Override
    public long getRequestSize() {
      return requestSize_;
    }
    /**
     *
     *
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     *
     * @param value The requestSize to set.
     * @return This builder for chaining.
     */
    public Builder setRequestSize(long value) {

      requestSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      requestSize_ = 0L;
      onChanged();
      return this;
    }

    private int status_;
    /**
     *
     *
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public int getStatus() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(int value) {

      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      status_ = 0;
      onChanged();
      return this;
    }

    private long responseSize_;
    /**
     *
     *
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     *
     * @return The responseSize.
     */
    @java.lang.Override
    public long getResponseSize() {
      return responseSize_;
    }
    /**
     *
     *
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     *
     * @param value The responseSize to set.
     * @return This builder for chaining.
     */
    public Builder setResponseSize(long value) {

      responseSize_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseSize() {
      bitField0_ = (bitField0_ & ~0x00000010);
      responseSize_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object userAgent_ = "";
    /**
     *
     *
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     *
     * @return The userAgent.
     */
    public java.lang.String getUserAgent() {
      java.lang.Object ref = userAgent_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     *
     * @return The bytes for userAgent.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getUserAgentBytes() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     *
     * @param value The userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userAgent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAgent() {
      userAgent_ = getDefaultInstance().getUserAgent();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     *
     * @param value The bytes for userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userAgent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object remoteIp_ = "";
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     *
     * @return The remoteIp.
     */
    public java.lang.String getRemoteIp() {
      java.lang.Object ref = remoteIp_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     *
     * @return The bytes for remoteIp.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRemoteIpBytes() {
      java.lang.Object ref = remoteIp_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteIp_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     *
     * @param value The remoteIp to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteIp() {
      remoteIp_ = getDefaultInstance().getRemoteIp();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     *
     * @param value The bytes for remoteIp to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteIpBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object serverIp_ = "";
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     *
     * @return The serverIp.
     */
    public java.lang.String getServerIp() {
      java.lang.Object ref = serverIp_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     *
     * @return The bytes for serverIp.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getServerIpBytes() {
      java.lang.Object ref = serverIp_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serverIp_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     *
     * @param value The serverIp to set.
     * @return This builder for chaining.
     */
    public Builder setServerIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serverIp_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServerIp() {
      serverIp_ = getDefaultInstance().getServerIp();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to. This field can include port information. Examples:
     * `"192.168.1.1"`, `"10.0.0.1:80"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     *
     * @param value The bytes for serverIp to set.
     * @return This builder for chaining.
     */
    public Builder setServerIpBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serverIp_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object referer_ = "";
    /**
     *
     *
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
     * </pre>
     *
     * <code>string referer = 8;</code>
     *
     * @return The referer.
     */
    public java.lang.String getReferer() {
      java.lang.Object ref = referer_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
     * </pre>
     *
     * <code>string referer = 8;</code>
     *
     * @return The bytes for referer.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRefererBytes() {
      java.lang.Object ref = referer_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        referer_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
     * </pre>
     *
     * <code>string referer = 8;</code>
     *
     * @param value The referer to set.
     * @return This builder for chaining.
     */
    public Builder setReferer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      referer_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
     * </pre>
     *
     * <code>string referer = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferer() {
      referer_ = getDefaultInstance().getReferer();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
     * </pre>
     *
     * <code>string referer = 8;</code>
     *
     * @param value The bytes for referer to set.
     * @return This builder for chaining.
     */
    public Builder setRefererBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      referer_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private org.hansken.ep.shade.com.google.protobuf.Duration latency_;
    private org.hansken.ep.shade.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            org.hansken.ep.shade.com.google.protobuf.Duration.Builder,
            org.hansken.ep.shade.com.google.protobuf.DurationOrBuilder>
        latencyBuilder_;
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     *
     * @return Whether the latency field is set.
     */
    public boolean hasLatency() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     *
     * @return The latency.
     */
    public org.hansken.ep.shade.com.google.protobuf.Duration getLatency() {
      if (latencyBuilder_ == null) {
        return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
      } else {
        return latencyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(org.hansken.ep.shade.com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latency_ = value;
      } else {
        latencyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(org.hansken.ep.shade.com.google.protobuf.Duration.Builder builderForValue) {
      if (latencyBuilder_ == null) {
        latency_ = builderForValue.build();
      } else {
        latencyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder mergeLatency(org.hansken.ep.shade.com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && latency_ != null
            && latency_ != org.hansken.ep.shade.com.google.protobuf.Duration.getDefaultInstance()) {
          getLatencyBuilder().mergeFrom(value);
        } else {
          latency_ = value;
        }
      } else {
        latencyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder clearLatency() {
      bitField0_ = (bitField0_ & ~0x00000200);
      latency_ = null;
      if (latencyBuilder_ != null) {
        latencyBuilder_.dispose();
        latencyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public org.hansken.ep.shade.com.google.protobuf.Duration.Builder getLatencyBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLatencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public org.hansken.ep.shade.com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
      if (latencyBuilder_ != null) {
        return latencyBuilder_.getMessageOrBuilder();
      } else {
        return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
      }
    }
    /**
     *
     *
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    private org.hansken.ep.shade.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            org.hansken.ep.shade.com.google.protobuf.Duration.Builder,
            org.hansken.ep.shade.com.google.protobuf.DurationOrBuilder>
        getLatencyFieldBuilder() {
      if (latencyBuilder_ == null) {
        latencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                org.hansken.ep.shade.com.google.protobuf.Duration.Builder,
                org.hansken.ep.shade.com.google.protobuf.DurationOrBuilder>(
                getLatency(), getParentForChildren(), isClean());
        latency_ = null;
      }
      return latencyBuilder_;
    }

    private boolean cacheLookup_;
    /**
     *
     *
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     *
     * @return The cacheLookup.
     */
    @java.lang.Override
    public boolean getCacheLookup() {
      return cacheLookup_;
    }
    /**
     *
     *
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     *
     * @param value The cacheLookup to set.
     * @return This builder for chaining.
     */
    public Builder setCacheLookup(boolean value) {

      cacheLookup_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCacheLookup() {
      bitField0_ = (bitField0_ & ~0x00000400);
      cacheLookup_ = false;
      onChanged();
      return this;
    }

    private boolean cacheHit_;
    /**
     *
     *
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     *
     * @return The cacheHit.
     */
    @java.lang.Override
    public boolean getCacheHit() {
      return cacheHit_;
    }
    /**
     *
     *
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     *
     * @param value The cacheHit to set.
     * @return This builder for chaining.
     */
    public Builder setCacheHit(boolean value) {

      cacheHit_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCacheHit() {
      bitField0_ = (bitField0_ & ~0x00000800);
      cacheHit_ = false;
      onChanged();
      return this;
    }

    private boolean cacheValidatedWithOriginServer_;
    /**
     *
     *
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     *
     * @return The cacheValidatedWithOriginServer.
     */
    @java.lang.Override
    public boolean getCacheValidatedWithOriginServer() {
      return cacheValidatedWithOriginServer_;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     *
     * @param value The cacheValidatedWithOriginServer to set.
     * @return This builder for chaining.
     */
    public Builder setCacheValidatedWithOriginServer(boolean value) {

      cacheValidatedWithOriginServer_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCacheValidatedWithOriginServer() {
      bitField0_ = (bitField0_ & ~0x00001000);
      cacheValidatedWithOriginServer_ = false;
      onChanged();
      return this;
    }

    private long cacheFillBytes_;
    /**
     *
     *
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     *
     * @return The cacheFillBytes.
     */
    @java.lang.Override
    public long getCacheFillBytes() {
      return cacheFillBytes_;
    }
    /**
     *
     *
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     *
     * @param value The cacheFillBytes to set.
     * @return This builder for chaining.
     */
    public Builder setCacheFillBytes(long value) {

      cacheFillBytes_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCacheFillBytes() {
      bitField0_ = (bitField0_ & ~0x00002000);
      cacheFillBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     *
     * @return The bytes for protocol.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.logging.type.HttpRequest)
  }

  // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.logging.type.HttpRequest)
  private static final org.hansken.ep.shade.com.google.logging.type.HttpRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.type.HttpRequest();
  }

  public static org.hansken.ep.shade.com.google.logging.type.HttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.hansken.ep.shade.com.google.protobuf.Parser<HttpRequest> PARSER =
      new com.google.protobuf.AbstractParser<HttpRequest>() {
        @java.lang.Override
        public HttpRequest parsePartialFrom(
            org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
            org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static org.hansken.ep.shade.com.google.protobuf.Parser<HttpRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Parser<HttpRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.logging.type.HttpRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
