/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.com.google.common.graph;

import java.util.Set;
import javax.annotation.CheckForNull;
import org.hansken.ep.shade.com.google.common.annotations.Beta;
import org.hansken.ep.shade.com.google.common.graph.ElementOrder;
import org.hansken.ep.shade.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.hansken.ep.shade.com.google.common.graph.EndpointPair;
import org.hansken.ep.shade.com.google.common.graph.Graph;
import org.hansken.ep.shade.com.google.common.graph.PredecessorsFunction;
import org.hansken.ep.shade.com.google.common.graph.SuccessorsFunction;
import org.hansken.ep.shade.com.google.errorprone.annotations.DoNotMock;

@DoNotMock(value="Use NetworkBuilder to create a real instance")
@ElementTypesAreNonnullByDefault
@Beta
public interface Network<N, E>
extends SuccessorsFunction<N>,
PredecessorsFunction<N> {
    public Set<N> nodes();

    public Set<E> edges();

    public Graph<N> asGraph();

    public boolean isDirected();

    public boolean allowsParallelEdges();

    public boolean allowsSelfLoops();

    public ElementOrder<N> nodeOrder();

    public ElementOrder<E> edgeOrder();

    public Set<N> adjacentNodes(N var1);

    @Override
    public Set<N> predecessors(N var1);

    @Override
    public Set<N> successors(N var1);

    public Set<E> incidentEdges(N var1);

    public Set<E> inEdges(N var1);

    public Set<E> outEdges(N var1);

    public int degree(N var1);

    public int inDegree(N var1);

    public int outDegree(N var1);

    public EndpointPair<N> incidentNodes(E var1);

    public Set<E> adjacentEdges(E var1);

    public Set<E> edgesConnecting(N var1, N var2);

    public Set<E> edgesConnecting(EndpointPair<N> var1);

    @CheckForNull
    public E edgeConnectingOrNull(N var1, N var2);

    @CheckForNull
    public E edgeConnectingOrNull(EndpointPair<N> var1);

    public boolean hasEdgeConnecting(N var1, N var2);

    public boolean hasEdgeConnecting(EndpointPair<N> var1);

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();
}

