/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/quota.proto

// Protobuf Java Version: 3.25.5
package org.hansken.ep.shade.com.google.api;

/**
 *
 *
 * <pre>
 * Quota configuration helps to achieve fairness and budgeting in service
 * usage.
 *
 * The metric based quota configuration works this way:
 * - The service configuration defines a set of metrics.
 * - For API calls, the quota.metric_rules maps methods to metrics with
 *   corresponding costs.
 * - The quota.limits defines limits on the metrics, which will be used for
 *   quota checks at runtime.
 *
 * An example quota configuration in yaml format:
 *
 *    quota:
 *      limits:
 *
 *      - name: apiWriteQpsPerProject
 *        metric: library.googleapis.com/write_calls
 *        unit: "1/min/{project}"  # rate limit for consumer projects
 *        values:
 *          STANDARD: 10000
 *
 *
 *      (The metric rules bind all methods to the read_calls metric,
 *       except for the UpdateBook and DeleteBook methods. These two methods
 *       are mapped to the write_calls metric, with the UpdateBook method
 *       consuming at twice rate as the DeleteBook method.)
 *      metric_rules:
 *      - selector: "*"
 *        metric_costs:
 *          library.googleapis.com/read_calls: 1
 *      - selector: google.example.library.v1.LibraryService.UpdateBook
 *        metric_costs:
 *          library.googleapis.com/write_calls: 2
 *      - selector: google.example.library.v1.LibraryService.DeleteBook
 *        metric_costs:
 *          library.googleapis.com/write_calls: 1
 *
 *  Corresponding Metric definition:
 *
 *      metrics:
 *      - name: library.googleapis.com/read_calls
 *        display_name: Read requests
 *        metric_kind: DELTA
 *        value_type: INT64
 *
 *      - name: library.googleapis.com/write_calls
 *        display_name: Write requests
 *        metric_kind: DELTA
 *        value_type: INT64
 * </pre>
 *
 * Protobuf type {@code google.api.Quota}
 */
public final class Quota extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.api.Quota)
    QuotaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Quota.newBuilder() to construct.
  private Quota(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Quota() {
    limits_ = java.util.Collections.emptyList();
    metricRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Quota();
  }

  public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
  }

  @java.lang.Override
  protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.QuotaProto.internal_static_google_api_Quota_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.hansken.ep.shade.com.google.api.Quota.class, org.hansken.ep.shade.com.google.api.Quota.Builder.class);
  }

  public static final int LIMITS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<org.hansken.ep.shade.com.google.api.QuotaLimit> limits_;
  /**
   *
   *
   * <pre>
   * List of QuotaLimit definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  @java.lang.Override
  public java.util.List<org.hansken.ep.shade.com.google.api.QuotaLimit> getLimitsList() {
    return limits_;
  }
  /**
   *
   *
   * <pre>
   * List of QuotaLimit definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder> getLimitsOrBuilderList() {
    return limits_;
  }
  /**
   *
   *
   * <pre>
   * List of QuotaLimit definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  @java.lang.Override
  public int getLimitsCount() {
    return limits_.size();
  }
  /**
   *
   *
   * <pre>
   * List of QuotaLimit definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.QuotaLimit getLimits(int index) {
    return limits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of QuotaLimit definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder getLimitsOrBuilder(int index) {
    return limits_.get(index);
  }

  public static final int METRIC_RULES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<org.hansken.ep.shade.com.google.api.MetricRule> metricRules_;
  /**
   *
   *
   * <pre>
   * List of MetricRule definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  @java.lang.Override
  public java.util.List<org.hansken.ep.shade.com.google.api.MetricRule> getMetricRulesList() {
    return metricRules_;
  }
  /**
   *
   *
   * <pre>
   * List of MetricRule definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder>
      getMetricRulesOrBuilderList() {
    return metricRules_;
  }
  /**
   *
   *
   * <pre>
   * List of MetricRule definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  @java.lang.Override
  public int getMetricRulesCount() {
    return metricRules_.size();
  }
  /**
   *
   *
   * <pre>
   * List of MetricRule definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.MetricRule getMetricRules(int index) {
    return metricRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of MetricRule definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder getMetricRulesOrBuilder(int index) {
    return metricRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < limits_.size(); i++) {
      output.writeMessage(3, limits_.get(i));
    }
    for (int i = 0; i < metricRules_.size(); i++) {
      output.writeMessage(4, metricRules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < limits_.size(); i++) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeMessageSize(3, limits_.get(i));
    }
    for (int i = 0; i < metricRules_.size(); i++) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeMessageSize(4, metricRules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Quota)) {
      return super.equals(obj);
    }
    org.hansken.ep.shade.com.google.api.Quota other = (org.hansken.ep.shade.com.google.api.Quota) obj;

    if (!getLimitsList().equals(other.getLimitsList())) return false;
    if (!getMetricRulesList().equals(other.getMetricRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLimitsCount() > 0) {
      hash = (37 * hash) + LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getLimitsList().hashCode();
    }
    if (getMetricRulesCount() > 0) {
      hash = (37 * hash) + METRIC_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getMetricRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(java.nio.ByteBuffer data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(
      java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(org.hansken.ep.shade.com.google.protobuf.ByteString data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(
      org.hansken.ep.shade.com.google.protobuf.ByteString data,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(byte[] data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(
      byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseDelimitedFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(org.hansken.ep.shade.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Quota parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.hansken.ep.shade.com.google.api.Quota prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Quota configuration helps to achieve fairness and budgeting in service
   * usage.
   *
   * The metric based quota configuration works this way:
   * - The service configuration defines a set of metrics.
   * - For API calls, the quota.metric_rules maps methods to metrics with
   *   corresponding costs.
   * - The quota.limits defines limits on the metrics, which will be used for
   *   quota checks at runtime.
   *
   * An example quota configuration in yaml format:
   *
   *    quota:
   *      limits:
   *
   *      - name: apiWriteQpsPerProject
   *        metric: library.googleapis.com/write_calls
   *        unit: "1/min/{project}"  # rate limit for consumer projects
   *        values:
   *          STANDARD: 10000
   *
   *
   *      (The metric rules bind all methods to the read_calls metric,
   *       except for the UpdateBook and DeleteBook methods. These two methods
   *       are mapped to the write_calls metric, with the UpdateBook method
   *       consuming at twice rate as the DeleteBook method.)
   *      metric_rules:
   *      - selector: "*"
   *        metric_costs:
   *          library.googleapis.com/read_calls: 1
   *      - selector: google.example.library.v1.LibraryService.UpdateBook
   *        metric_costs:
   *          library.googleapis.com/write_calls: 2
   *      - selector: google.example.library.v1.LibraryService.DeleteBook
   *        metric_costs:
   *          library.googleapis.com/write_calls: 1
   *
   *  Corresponding Metric definition:
   *
   *      metrics:
   *      - name: library.googleapis.com/read_calls
   *        display_name: Read requests
   *        metric_kind: DELTA
   *        value_type: INT64
   *
   *      - name: library.googleapis.com/write_calls
   *        display_name: Write requests
   *        metric_kind: DELTA
   *        value_type: INT64
   * </pre>
   *
   * Protobuf type {@code google.api.Quota}
   */
  public static final class Builder extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.api.Quota)
      com.google.api.QuotaOrBuilder {
    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.api.Quota.class, org.hansken.ep.shade.com.google.api.Quota.Builder.class);
    }

    // Construct using com.google.api.Quota.newBuilder()
    private Builder() {}

    private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (limitsBuilder_ == null) {
        limits_ = java.util.Collections.emptyList();
      } else {
        limits_ = null;
        limitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (metricRulesBuilder_ == null) {
        metricRules_ = java.util.Collections.emptyList();
      } else {
        metricRules_ = null;
        metricRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Quota getDefaultInstanceForType() {
      return com.google.api.Quota.getDefaultInstance();
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Quota build() {
      org.hansken.ep.shade.com.google.api.Quota result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Quota buildPartial() {
      org.hansken.ep.shade.com.google.api.Quota result = new com.google.api.Quota(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(org.hansken.ep.shade.com.google.api.Quota result) {
      if (limitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          limits_ = java.util.Collections.unmodifiableList(limits_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.limits_ = limits_;
      } else {
        result.limits_ = limitsBuilder_.build();
      }
      if (metricRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metricRules_ = java.util.Collections.unmodifiableList(metricRules_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metricRules_ = metricRules_;
      } else {
        result.metricRules_ = metricRulesBuilder_.build();
      }
    }

    private void buildPartial0(org.hansken.ep.shade.com.google.api.Quota result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Quota) {
        return mergeFrom((org.hansken.ep.shade.com.google.api.Quota) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.hansken.ep.shade.com.google.api.Quota other) {
      if (other == org.hansken.ep.shade.com.google.api.Quota.getDefaultInstance()) return this;
      if (limitsBuilder_ == null) {
        if (!other.limits_.isEmpty()) {
          if (limits_.isEmpty()) {
            limits_ = other.limits_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLimitsIsMutable();
            limits_.addAll(other.limits_);
          }
          onChanged();
        }
      } else {
        if (!other.limits_.isEmpty()) {
          if (limitsBuilder_.isEmpty()) {
            limitsBuilder_.dispose();
            limitsBuilder_ = null;
            limits_ = other.limits_;
            bitField0_ = (bitField0_ & ~0x00000001);
            limitsBuilder_ =
                org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLimitsFieldBuilder()
                    : null;
          } else {
            limitsBuilder_.addAllMessages(other.limits_);
          }
        }
      }
      if (metricRulesBuilder_ == null) {
        if (!other.metricRules_.isEmpty()) {
          if (metricRules_.isEmpty()) {
            metricRules_ = other.metricRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricRulesIsMutable();
            metricRules_.addAll(other.metricRules_);
          }
          onChanged();
        }
      } else {
        if (!other.metricRules_.isEmpty()) {
          if (metricRulesBuilder_.isEmpty()) {
            metricRulesBuilder_.dispose();
            metricRulesBuilder_ = null;
            metricRules_ = other.metricRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metricRulesBuilder_ =
                org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricRulesFieldBuilder()
                    : null;
          } else {
            metricRulesBuilder_.addAllMessages(other.metricRules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                org.hansken.ep.shade.com.google.api.QuotaLimit m =
                    input.readMessage(org.hansken.ep.shade.com.google.api.QuotaLimit.parser(), extensionRegistry);
                if (limitsBuilder_ == null) {
                  ensureLimitsIsMutable();
                  limits_.add(m);
                } else {
                  limitsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                org.hansken.ep.shade.com.google.api.MetricRule m =
                    input.readMessage(org.hansken.ep.shade.com.google.api.MetricRule.parser(), extensionRegistry);
                if (metricRulesBuilder_ == null) {
                  ensureMetricRulesIsMutable();
                  metricRules_.add(m);
                } else {
                  metricRulesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<org.hansken.ep.shade.com.google.api.QuotaLimit> limits_ = java.util.Collections.emptyList();

    private void ensureLimitsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        limits_ = new java.util.ArrayList<org.hansken.ep.shade.com.google.api.QuotaLimit>(limits_);
        bitField0_ |= 0x00000001;
      }
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.QuotaLimit,
            org.hansken.ep.shade.com.google.api.QuotaLimit.Builder,
            org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder>
        limitsBuilder_;

    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.QuotaLimit> getLimitsList() {
      if (limitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(limits_);
      } else {
        return limitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public int getLimitsCount() {
      if (limitsBuilder_ == null) {
        return limits_.size();
      } else {
        return limitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public org.hansken.ep.shade.com.google.api.QuotaLimit getLimits(int index) {
      if (limitsBuilder_ == null) {
        return limits_.get(index);
      } else {
        return limitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder setLimits(int index, org.hansken.ep.shade.com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.set(index, value);
        onChanged();
      } else {
        limitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder setLimits(int index, org.hansken.ep.shade.com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.set(index, builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(org.hansken.ep.shade.com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.add(value);
        onChanged();
      } else {
        limitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(int index, org.hansken.ep.shade.com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.add(index, value);
        onChanged();
      } else {
        limitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(org.hansken.ep.shade.com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.add(builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(int index, org.hansken.ep.shade.com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.add(index, builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addAllLimits(java.lang.Iterable<? extends org.hansken.ep.shade.com.google.api.QuotaLimit> values) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, limits_);
        onChanged();
      } else {
        limitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder clearLimits() {
      if (limitsBuilder_ == null) {
        limits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        limitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder removeLimits(int index) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.remove(index);
        onChanged();
      } else {
        limitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public org.hansken.ep.shade.com.google.api.QuotaLimit.Builder getLimitsBuilder(int index) {
      return getLimitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder getLimitsOrBuilder(int index) {
      if (limitsBuilder_ == null) {
        return limits_.get(index);
      } else {
        return limitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<? extends org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder> getLimitsOrBuilderList() {
      if (limitsBuilder_ != null) {
        return limitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(limits_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public org.hansken.ep.shade.com.google.api.QuotaLimit.Builder addLimitsBuilder() {
      return getLimitsFieldBuilder().addBuilder(org.hansken.ep.shade.com.google.api.QuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public org.hansken.ep.shade.com.google.api.QuotaLimit.Builder addLimitsBuilder(int index) {
      return getLimitsFieldBuilder()
          .addBuilder(index, org.hansken.ep.shade.com.google.api.QuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of QuotaLimit definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.QuotaLimit.Builder> getLimitsBuilderList() {
      return getLimitsFieldBuilder().getBuilderList();
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.QuotaLimit,
            org.hansken.ep.shade.com.google.api.QuotaLimit.Builder,
            org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder>
        getLimitsFieldBuilder() {
      if (limitsBuilder_ == null) {
        limitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.QuotaLimit,
                org.hansken.ep.shade.com.google.api.QuotaLimit.Builder,
                org.hansken.ep.shade.com.google.api.QuotaLimitOrBuilder>(
                limits_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        limits_ = null;
      }
      return limitsBuilder_;
    }

    private java.util.List<org.hansken.ep.shade.com.google.api.MetricRule> metricRules_ =
        java.util.Collections.emptyList();

    private void ensureMetricRulesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metricRules_ = new java.util.ArrayList<org.hansken.ep.shade.com.google.api.MetricRule>(metricRules_);
        bitField0_ |= 0x00000002;
      }
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricRule,
            org.hansken.ep.shade.com.google.api.MetricRule.Builder,
            org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder>
        metricRulesBuilder_;

    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.MetricRule> getMetricRulesList() {
      if (metricRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metricRules_);
      } else {
        return metricRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public int getMetricRulesCount() {
      if (metricRulesBuilder_ == null) {
        return metricRules_.size();
      } else {
        return metricRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public org.hansken.ep.shade.com.google.api.MetricRule getMetricRules(int index) {
      if (metricRulesBuilder_ == null) {
        return metricRules_.get(index);
      } else {
        return metricRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder setMetricRules(int index, org.hansken.ep.shade.com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.set(index, value);
        onChanged();
      } else {
        metricRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder setMetricRules(int index, org.hansken.ep.shade.com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(org.hansken.ep.shade.com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.add(value);
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(int index, org.hansken.ep.shade.com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.add(index, value);
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(org.hansken.ep.shade.com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.add(builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(int index, org.hansken.ep.shade.com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addAllMetricRules(
        java.lang.Iterable<? extends org.hansken.ep.shade.com.google.api.MetricRule> values) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metricRules_);
        onChanged();
      } else {
        metricRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder clearMetricRules() {
      if (metricRulesBuilder_ == null) {
        metricRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metricRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder removeMetricRules(int index) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.remove(index);
        onChanged();
      } else {
        metricRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public org.hansken.ep.shade.com.google.api.MetricRule.Builder getMetricRulesBuilder(int index) {
      return getMetricRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder getMetricRulesOrBuilder(int index) {
      if (metricRulesBuilder_ == null) {
        return metricRules_.get(index);
      } else {
        return metricRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<? extends org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder>
        getMetricRulesOrBuilderList() {
      if (metricRulesBuilder_ != null) {
        return metricRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metricRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public org.hansken.ep.shade.com.google.api.MetricRule.Builder addMetricRulesBuilder() {
      return getMetricRulesFieldBuilder()
          .addBuilder(org.hansken.ep.shade.com.google.api.MetricRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public org.hansken.ep.shade.com.google.api.MetricRule.Builder addMetricRulesBuilder(int index) {
      return getMetricRulesFieldBuilder()
          .addBuilder(index, org.hansken.ep.shade.com.google.api.MetricRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of MetricRule definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.MetricRule.Builder> getMetricRulesBuilderList() {
      return getMetricRulesFieldBuilder().getBuilderList();
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricRule,
            org.hansken.ep.shade.com.google.api.MetricRule.Builder,
            org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder>
        getMetricRulesFieldBuilder() {
      if (metricRulesBuilder_ == null) {
        metricRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MetricRule,
                org.hansken.ep.shade.com.google.api.MetricRule.Builder,
                org.hansken.ep.shade.com.google.api.MetricRuleOrBuilder>(
                metricRules_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        metricRules_ = null;
      }
      return metricRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.api.Quota)
  }

  // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.api.Quota)
  private static final org.hansken.ep.shade.com.google.api.Quota DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Quota();
  }

  public static org.hansken.ep.shade.com.google.api.Quota getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.hansken.ep.shade.com.google.protobuf.Parser<Quota> PARSER =
      new com.google.protobuf.AbstractParser<Quota>() {
        @java.lang.Override
        public Quota parsePartialFrom(
            org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
            org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static org.hansken.ep.shade.com.google.protobuf.Parser<Quota> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Parser<Quota> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Quota getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
