/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/type/postal_address.proto

// Protobuf Java Version: 3.25.5
package org.hansken.ep.shade.com.google.type;

/**
 *
 *
 * <pre>
 * Represents a postal address, e.g. for postal delivery or payments addresses.
 * Given a postal address, a postal service can deliver items to a premise, P.O.
 * Box or similar.
 * It is not intended to model geographical locations (roads, towns,
 * mountains).
 *
 * In typical usage an address would be created via user input or from importing
 * existing data, depending on the type of process.
 *
 * Advice on address input / editing:
 *  - Use an i18n-ready address widget such as
 *    https://github.com/google/libaddressinput)
 * - Users should not be presented with UI elements for input or editing of
 *   fields outside countries where that field is used.
 *
 * For more guidance on how to use this schema, please see:
 * https://support.google.com/business/answer/6397478
 * </pre>
 *
 * Protobuf type {@code google.type.PostalAddress}
 */
public final class PostalAddress extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.type.PostalAddress)
    PostalAddressOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PostalAddress.newBuilder() to construct.
  private PostalAddress(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PostalAddress() {
    regionCode_ = "";
    languageCode_ = "";
    postalCode_ = "";
    sortingCode_ = "";
    administrativeArea_ = "";
    locality_ = "";
    sublocality_ = "";
    addressLines_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
    recipients_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
    organization_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PostalAddress();
  }

  public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_descriptor;
  }

  @java.lang.Override
  protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.type.PostalAddressProto
        .internal_static_google_type_PostalAddress_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.hansken.ep.shade.com.google.type.PostalAddress.class, org.hansken.ep.shade.com.google.type.PostalAddress.Builder.class);
  }

  public static final int REVISION_FIELD_NUMBER = 1;
  private int revision_ = 0;
  /**
   *
   *
   * <pre>
   * The schema revision of the `PostalAddress`. This must be set to 0, which is
   * the latest revision.
   *
   * All new revisions **must** be backward compatible with old revisions.
   * </pre>
   *
   * <code>int32 revision = 1;</code>
   *
   * @return The revision.
   */
  @java.lang.Override
  public int getRevision() {
    return revision_;
  }

  public static final int REGION_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regionCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. CLDR region code of the country/region of the address. This
   * is never inferred and it is up to the user to ensure the value is
   * correct. See http://cldr.unicode.org/ and
   * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   *
   * @return The regionCode.
   */
  @java.lang.Override
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. CLDR region code of the country/region of the address. This
   * is never inferred and it is up to the user to ensure the value is
   * correct. See http://cldr.unicode.org/ and
   * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   *
   * @return The bytes for regionCode.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. BCP-47 language code of the contents of this address (if
   * known). This is often the UI language of the input form or is expected
   * to match one of the languages used in the address' country/region, or their
   * transliterated equivalents.
   * This can affect formatting in certain countries, but is not critical
   * to the correctness of the data and will never affect any validation or
   * other non-formatting related operations.
   *
   * If this value is not known, it should be omitted (rather than specifying a
   * possibly incorrect default).
   *
   * Examples: "zh-Hant", "ja", "ja-Latn", "en".
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. BCP-47 language code of the contents of this address (if
   * known). This is often the UI language of the input form or is expected
   * to match one of the languages used in the address' country/region, or their
   * transliterated equivalents.
   * This can affect formatting in certain countries, but is not critical
   * to the correctness of the data and will never affect any validation or
   * other non-formatting related operations.
   *
   * If this value is not known, it should be omitted (rather than specifying a
   * possibly incorrect default).
   *
   * Examples: "zh-Hant", "ja", "ja-Latn", "en".
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTAL_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postalCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Postal code of the address. Not all countries use or require
   * postal codes to be present, but where they are used, they may trigger
   * additional validation with other parts of the address (e.g. state/zip
   * validation in the U.S.A.).
   * </pre>
   *
   * <code>string postal_code = 4;</code>
   *
   * @return The postalCode.
   */
  @java.lang.Override
  public java.lang.String getPostalCode() {
    java.lang.Object ref = postalCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postalCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Postal code of the address. Not all countries use or require
   * postal codes to be present, but where they are used, they may trigger
   * additional validation with other parts of the address (e.g. state/zip
   * validation in the U.S.A.).
   * </pre>
   *
   * <code>string postal_code = 4;</code>
   *
   * @return The bytes for postalCode.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getPostalCodeBytes() {
    java.lang.Object ref = postalCode_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postalCode_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SORTING_CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sortingCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Additional, country-specific, sorting code. This is not used
   * in most regions. Where it is used, the value is either a string like
   * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
   * alone, representing the "sector code" (Jamaica), "delivery area indicator"
   * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
   * </pre>
   *
   * <code>string sorting_code = 5;</code>
   *
   * @return The sortingCode.
   */
  @java.lang.Override
  public java.lang.String getSortingCode() {
    java.lang.Object ref = sortingCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sortingCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional, country-specific, sorting code. This is not used
   * in most regions. Where it is used, the value is either a string like
   * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
   * alone, representing the "sector code" (Jamaica), "delivery area indicator"
   * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
   * </pre>
   *
   * <code>string sorting_code = 5;</code>
   *
   * @return The bytes for sortingCode.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getSortingCodeBytes() {
    java.lang.Object ref = sortingCode_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sortingCode_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADMINISTRATIVE_AREA_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object administrativeArea_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Highest administrative subdivision which is used for postal
   * addresses of a country or region.
   * For example, this can be a state, a province, an oblast, or a prefecture.
   * Specifically, for Spain this is the province and not the autonomous
   * community (e.g. "Barcelona" and not "Catalonia").
   * Many countries don't use an administrative area in postal addresses. E.g.
   * in Switzerland this should be left unpopulated.
   * </pre>
   *
   * <code>string administrative_area = 6;</code>
   *
   * @return The administrativeArea.
   */
  @java.lang.Override
  public java.lang.String getAdministrativeArea() {
    java.lang.Object ref = administrativeArea_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      administrativeArea_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Highest administrative subdivision which is used for postal
   * addresses of a country or region.
   * For example, this can be a state, a province, an oblast, or a prefecture.
   * Specifically, for Spain this is the province and not the autonomous
   * community (e.g. "Barcelona" and not "Catalonia").
   * Many countries don't use an administrative area in postal addresses. E.g.
   * in Switzerland this should be left unpopulated.
   * </pre>
   *
   * <code>string administrative_area = 6;</code>
   *
   * @return The bytes for administrativeArea.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getAdministrativeAreaBytes() {
    java.lang.Object ref = administrativeArea_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      administrativeArea_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALITY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locality_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Generally refers to the city/town portion of the address.
   * Examples: US city, IT comune, UK post town.
   * In regions of the world where localities are not well defined or do not fit
   * into this structure well, leave locality empty and use address_lines.
   * </pre>
   *
   * <code>string locality = 7;</code>
   *
   * @return The locality.
   */
  @java.lang.Override
  public java.lang.String getLocality() {
    java.lang.Object ref = locality_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locality_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Generally refers to the city/town portion of the address.
   * Examples: US city, IT comune, UK post town.
   * In regions of the world where localities are not well defined or do not fit
   * into this structure well, leave locality empty and use address_lines.
   * </pre>
   *
   * <code>string locality = 7;</code>
   *
   * @return The bytes for locality.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getLocalityBytes() {
    java.lang.Object ref = locality_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locality_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBLOCALITY_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sublocality_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Sublocality of the address.
   * For example, this can be neighborhoods, boroughs, districts.
   * </pre>
   *
   * <code>string sublocality = 8;</code>
   *
   * @return The sublocality.
   */
  @java.lang.Override
  public java.lang.String getSublocality() {
    java.lang.Object ref = sublocality_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sublocality_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Sublocality of the address.
   * For example, this can be neighborhoods, boroughs, districts.
   * </pre>
   *
   * <code>string sublocality = 8;</code>
   *
   * @return The bytes for sublocality.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getSublocalityBytes() {
    java.lang.Object ref = sublocality_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sublocality_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDRESS_LINES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList addressLines_ =
      org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   *
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   *
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address components until it was at least
   * partially resolved.
   *
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle completely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   *
   * @return A list containing the addressLines.
   */
  public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getAddressLinesList() {
    return addressLines_;
  }
  /**
   *
   *
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   *
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   *
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address components until it was at least
   * partially resolved.
   *
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle completely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   *
   * @return The count of addressLines.
   */
  public int getAddressLinesCount() {
    return addressLines_.size();
  }
  /**
   *
   *
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   *
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   *
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address components until it was at least
   * partially resolved.
   *
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle completely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The addressLines at the given index.
   */
  public java.lang.String getAddressLines(int index) {
    return addressLines_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   *
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   *
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address components until it was at least
   * partially resolved.
   *
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle completely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the addressLines at the given index.
   */
  public org.hansken.ep.shade.com.google.protobuf.ByteString getAddressLinesBytes(int index) {
    return addressLines_.getByteString(index);
  }

  public static final int RECIPIENTS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList recipients_ =
      org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   *
   * @return A list containing the recipients.
   */
  public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getRecipientsList() {
    return recipients_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   *
   * @return The count of recipients.
   */
  public int getRecipientsCount() {
    return recipients_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The recipients at the given index.
   */
  public java.lang.String getRecipients(int index) {
    return recipients_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the recipients at the given index.
   */
  public org.hansken.ep.shade.com.google.protobuf.ByteString getRecipientsBytes(int index) {
    return recipients_.getByteString(index);
  }

  public static final int ORGANIZATION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object organization_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the organization at the address.
   * </pre>
   *
   * <code>string organization = 11;</code>
   *
   * @return The organization.
   */
  @java.lang.Override
  public java.lang.String getOrganization() {
    java.lang.Object ref = organization_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      organization_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the organization at the address.
   * </pre>
   *
   * <code>string organization = 11;</code>
   *
   * @return The bytes for organization.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.ByteString getOrganizationBytes() {
    java.lang.Object ref = organization_;
    if (ref instanceof java.lang.String) {
      org.hansken.ep.shade.com.google.protobuf.ByteString b =
          org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      organization_ = b;
      return b;
    } else {
      return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (revision_ != 0) {
      output.writeInt32(1, revision_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, regionCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(postalCode_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 4, postalCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(sortingCode_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sortingCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(administrativeArea_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 6, administrativeArea_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(locality_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 7, locality_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(sublocality_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sublocality_);
    }
    for (int i = 0; i < addressLines_.size(); i++) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 9, addressLines_.getRaw(i));
    }
    for (int i = 0; i < recipients_.size(); i++) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 10, recipients_.getRaw(i));
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(organization_)) {
      org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 11, organization_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (revision_ != 0) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeInt32Size(1, revision_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, regionCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(postalCode_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(4, postalCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(sortingCode_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(5, sortingCode_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(administrativeArea_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(6, administrativeArea_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(locality_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(7, locality_);
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(sublocality_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(8, sublocality_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < addressLines_.size(); i++) {
        dataSize += computeStringSizeNoTag(addressLines_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAddressLinesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < recipients_.size(); i++) {
        dataSize += computeStringSizeNoTag(recipients_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRecipientsList().size();
    }
    if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(organization_)) {
      size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(11, organization_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.type.PostalAddress)) {
      return super.equals(obj);
    }
    org.hansken.ep.shade.com.google.type.PostalAddress other = (org.hansken.ep.shade.com.google.type.PostalAddress) obj;

    if (getRevision() != other.getRevision()) return false;
    if (!getRegionCode().equals(other.getRegionCode())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getPostalCode().equals(other.getPostalCode())) return false;
    if (!getSortingCode().equals(other.getSortingCode())) return false;
    if (!getAdministrativeArea().equals(other.getAdministrativeArea())) return false;
    if (!getLocality().equals(other.getLocality())) return false;
    if (!getSublocality().equals(other.getSublocality())) return false;
    if (!getAddressLinesList().equals(other.getAddressLinesList())) return false;
    if (!getRecipientsList().equals(other.getRecipientsList())) return false;
    if (!getOrganization().equals(other.getOrganization())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision();
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + POSTAL_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getPostalCode().hashCode();
    hash = (37 * hash) + SORTING_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSortingCode().hashCode();
    hash = (37 * hash) + ADMINISTRATIVE_AREA_FIELD_NUMBER;
    hash = (53 * hash) + getAdministrativeArea().hashCode();
    hash = (37 * hash) + LOCALITY_FIELD_NUMBER;
    hash = (53 * hash) + getLocality().hashCode();
    hash = (37 * hash) + SUBLOCALITY_FIELD_NUMBER;
    hash = (53 * hash) + getSublocality().hashCode();
    if (getAddressLinesCount() > 0) {
      hash = (37 * hash) + ADDRESS_LINES_FIELD_NUMBER;
      hash = (53 * hash) + getAddressLinesList().hashCode();
    }
    if (getRecipientsCount() > 0) {
      hash = (37 * hash) + RECIPIENTS_FIELD_NUMBER;
      hash = (53 * hash) + getRecipientsList().hashCode();
    }
    hash = (37 * hash) + ORGANIZATION_FIELD_NUMBER;
    hash = (53 * hash) + getOrganization().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(java.nio.ByteBuffer data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(
      java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(org.hansken.ep.shade.com.google.protobuf.ByteString data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(
      org.hansken.ep.shade.com.google.protobuf.ByteString data,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(byte[] data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(
      byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseDelimitedFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(org.hansken.ep.shade.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.hansken.ep.shade.com.google.type.PostalAddress prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a postal address, e.g. for postal delivery or payments addresses.
   * Given a postal address, a postal service can deliver items to a premise, P.O.
   * Box or similar.
   * It is not intended to model geographical locations (roads, towns,
   * mountains).
   *
   * In typical usage an address would be created via user input or from importing
   * existing data, depending on the type of process.
   *
   * Advice on address input / editing:
   *  - Use an i18n-ready address widget such as
   *    https://github.com/google/libaddressinput)
   * - Users should not be presented with UI elements for input or editing of
   *   fields outside countries where that field is used.
   *
   * For more guidance on how to use this schema, please see:
   * https://support.google.com/business/answer/6397478
   * </pre>
   *
   * Protobuf type {@code google.type.PostalAddress}
   */
  public static final class Builder extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.type.PostalAddress)
      com.google.type.PostalAddressOrBuilder {
    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.type.PostalAddressProto
          .internal_static_google_type_PostalAddress_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.type.PostalAddressProto
          .internal_static_google_type_PostalAddress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.type.PostalAddress.class, org.hansken.ep.shade.com.google.type.PostalAddress.Builder.class);
    }

    // Construct using com.google.type.PostalAddress.newBuilder()
    private Builder() {}

    private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      revision_ = 0;
      regionCode_ = "";
      languageCode_ = "";
      postalCode_ = "";
      sortingCode_ = "";
      administrativeArea_ = "";
      locality_ = "";
      sublocality_ = "";
      addressLines_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
      recipients_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
      organization_ = "";
      return this;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.type.PostalAddressProto
          .internal_static_google_type_PostalAddress_descriptor;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.type.PostalAddress getDefaultInstanceForType() {
      return com.google.type.PostalAddress.getDefaultInstance();
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.type.PostalAddress build() {
      org.hansken.ep.shade.com.google.type.PostalAddress result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.type.PostalAddress buildPartial() {
      org.hansken.ep.shade.com.google.type.PostalAddress result = new com.google.type.PostalAddress(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(org.hansken.ep.shade.com.google.type.PostalAddress result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.revision_ = revision_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.regionCode_ = regionCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.postalCode_ = postalCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sortingCode_ = sortingCode_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.administrativeArea_ = administrativeArea_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.locality_ = locality_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.sublocality_ = sublocality_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        addressLines_.makeImmutable();
        result.addressLines_ = addressLines_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        recipients_.makeImmutable();
        result.recipients_ = recipients_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.organization_ = organization_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
      if (other instanceof com.google.type.PostalAddress) {
        return mergeFrom((org.hansken.ep.shade.com.google.type.PostalAddress) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.hansken.ep.shade.com.google.type.PostalAddress other) {
      if (other == org.hansken.ep.shade.com.google.type.PostalAddress.getDefaultInstance()) return this;
      if (other.getRevision() != 0) {
        setRevision(other.getRevision());
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPostalCode().isEmpty()) {
        postalCode_ = other.postalCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getSortingCode().isEmpty()) {
        sortingCode_ = other.sortingCode_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getAdministrativeArea().isEmpty()) {
        administrativeArea_ = other.administrativeArea_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getLocality().isEmpty()) {
        locality_ = other.locality_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getSublocality().isEmpty()) {
        sublocality_ = other.sublocality_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.addressLines_.isEmpty()) {
        if (addressLines_.isEmpty()) {
          addressLines_ = other.addressLines_;
          bitField0_ |= 0x00000100;
        } else {
          ensureAddressLinesIsMutable();
          addressLines_.addAll(other.addressLines_);
        }
        onChanged();
      }
      if (!other.recipients_.isEmpty()) {
        if (recipients_.isEmpty()) {
          recipients_ = other.recipients_;
          bitField0_ |= 0x00000200;
        } else {
          ensureRecipientsIsMutable();
          recipients_.addAll(other.recipients_);
        }
        onChanged();
      }
      if (!other.getOrganization().isEmpty()) {
        organization_ = other.organization_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                revision_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                regionCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                postalCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                sortingCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                administrativeArea_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                locality_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                sublocality_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAddressLinesIsMutable();
                addressLines_.add(s);
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRecipientsIsMutable();
                recipients_.add(s);
                break;
              } // case 82
            case 90:
              {
                organization_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int revision_;
    /**
     *
     *
     * <pre>
     * The schema revision of the `PostalAddress`. This must be set to 0, which is
     * the latest revision.
     *
     * All new revisions **must** be backward compatible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     *
     * @return The revision.
     */
    @java.lang.Override
    public int getRevision() {
      return revision_;
    }
    /**
     *
     *
     * <pre>
     * The schema revision of the `PostalAddress`. This must be set to 0, which is
     * the latest revision.
     *
     * All new revisions **must** be backward compatible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     *
     * @param value The revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevision(int value) {

      revision_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema revision of the `PostalAddress`. This must be set to 0, which is
     * the latest revision.
     *
     * All new revisions **must** be backward compatible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevision() {
      bitField0_ = (bitField0_ & ~0x00000001);
      revision_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.org/ and
     * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return The regionCode.
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.org/ and
     * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return The bytes for regionCode.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.org/ and
     * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @param value The regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regionCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.org/ and
     * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegionCode() {
      regionCode_ = getDefaultInstance().getRegionCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.org/ and
     * http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @param value The bytes for regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCodeBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regionCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     *
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     *
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     *
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     *
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return The bytes for languageCode.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     *
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     *
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     *
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     *
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     *
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     *
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object postalCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     *
     * @return The postalCode.
     */
    public java.lang.String getPostalCode() {
      java.lang.Object ref = postalCode_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postalCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     *
     * @return The bytes for postalCode.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getPostalCodeBytes() {
      java.lang.Object ref = postalCode_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postalCode_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     *
     * @param value The postalCode to set.
     * @return This builder for chaining.
     */
    public Builder setPostalCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postalCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostalCode() {
      postalCode_ = getDefaultInstance().getPostalCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     *
     * @param value The bytes for postalCode to set.
     * @return This builder for chaining.
     */
    public Builder setPostalCodeBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postalCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object sortingCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     *
     * @return The sortingCode.
     */
    public java.lang.String getSortingCode() {
      java.lang.Object ref = sortingCode_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sortingCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     *
     * @return The bytes for sortingCode.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getSortingCodeBytes() {
      java.lang.Object ref = sortingCode_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sortingCode_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     *
     * @param value The sortingCode to set.
     * @return This builder for chaining.
     */
    public Builder setSortingCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sortingCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSortingCode() {
      sortingCode_ = getDefaultInstance().getSortingCode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     *
     * @param value The bytes for sortingCode to set.
     * @return This builder for chaining.
     */
    public Builder setSortingCodeBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sortingCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object administrativeArea_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * community (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     *
     * @return The administrativeArea.
     */
    public java.lang.String getAdministrativeArea() {
      java.lang.Object ref = administrativeArea_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        administrativeArea_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * community (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     *
     * @return The bytes for administrativeArea.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getAdministrativeAreaBytes() {
      java.lang.Object ref = administrativeArea_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        administrativeArea_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * community (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     *
     * @param value The administrativeArea to set.
     * @return This builder for chaining.
     */
    public Builder setAdministrativeArea(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      administrativeArea_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * community (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdministrativeArea() {
      administrativeArea_ = getDefaultInstance().getAdministrativeArea();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * community (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     *
     * @param value The bytes for administrativeArea to set.
     * @return This builder for chaining.
     */
    public Builder setAdministrativeAreaBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      administrativeArea_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object locality_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT comune, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     *
     * @return The locality.
     */
    public java.lang.String getLocality() {
      java.lang.Object ref = locality_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locality_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT comune, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     *
     * @return The bytes for locality.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getLocalityBytes() {
      java.lang.Object ref = locality_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locality_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT comune, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     *
     * @param value The locality to set.
     * @return This builder for chaining.
     */
    public Builder setLocality(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locality_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT comune, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocality() {
      locality_ = getDefaultInstance().getLocality();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT comune, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     *
     * @param value The bytes for locality to set.
     * @return This builder for chaining.
     */
    public Builder setLocalityBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locality_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object sublocality_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     *
     * @return The sublocality.
     */
    public java.lang.String getSublocality() {
      java.lang.Object ref = sublocality_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sublocality_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     *
     * @return The bytes for sublocality.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getSublocalityBytes() {
      java.lang.Object ref = sublocality_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sublocality_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     *
     * @param value The sublocality to set.
     * @return This builder for chaining.
     */
    public Builder setSublocality(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sublocality_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSublocality() {
      sublocality_ = getDefaultInstance().getSublocality();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     *
     * @param value The bytes for sublocality to set.
     * @return This builder for chaining.
     */
    public Builder setSublocalityBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sublocality_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList addressLines_ =
        org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAddressLinesIsMutable() {
      if (!addressLines_.isModifiable()) {
        addressLines_ = new com.google.protobuf.LazyStringArrayList(addressLines_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @return A list containing the addressLines.
     */
    public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getAddressLinesList() {
      addressLines_.makeImmutable();
      return addressLines_;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @return The count of addressLines.
     */
    public int getAddressLinesCount() {
      return addressLines_.size();
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The addressLines at the given index.
     */
    public java.lang.String getAddressLines(int index) {
      return addressLines_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the addressLines at the given index.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getAddressLinesBytes(int index) {
      return addressLines_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The addressLines to set.
     * @return This builder for chaining.
     */
    public Builder setAddressLines(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAddressLinesIsMutable();
      addressLines_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param value The addressLines to add.
     * @return This builder for chaining.
     */
    public Builder addAddressLines(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAddressLinesIsMutable();
      addressLines_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param values The addressLines to add.
     * @return This builder for chaining.
     */
    public Builder addAllAddressLines(java.lang.Iterable<java.lang.String> values) {
      ensureAddressLinesIsMutable();
      org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, addressLines_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddressLines() {
      addressLines_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     *
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     *
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address components until it was at least
     * partially resolved.
     *
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle completely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     *
     * @param value The bytes of the addressLines to add.
     * @return This builder for chaining.
     */
    public Builder addAddressLinesBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAddressLinesIsMutable();
      addressLines_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList recipients_ =
        org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRecipientsIsMutable() {
      if (!recipients_.isModifiable()) {
        recipients_ = new com.google.protobuf.LazyStringArrayList(recipients_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @return A list containing the recipients.
     */
    public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getRecipientsList() {
      recipients_.makeImmutable();
      return recipients_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @return The count of recipients.
     */
    public int getRecipientsCount() {
      return recipients_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The recipients at the given index.
     */
    public java.lang.String getRecipients(int index) {
      return recipients_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the recipients at the given index.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getRecipientsBytes(int index) {
      return recipients_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The recipients to set.
     * @return This builder for chaining.
     */
    public Builder setRecipients(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRecipientsIsMutable();
      recipients_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param value The recipients to add.
     * @return This builder for chaining.
     */
    public Builder addRecipients(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRecipientsIsMutable();
      recipients_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param values The recipients to add.
     * @return This builder for chaining.
     */
    public Builder addAllRecipients(java.lang.Iterable<java.lang.String> values) {
      ensureRecipientsIsMutable();
      org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, recipients_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecipients() {
      recipients_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     *
     * @param value The bytes of the recipients to add.
     * @return This builder for chaining.
     */
    public Builder addRecipientsBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRecipientsIsMutable();
      recipients_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object organization_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the organization at the address.
     * </pre>
     *
     * <code>string organization = 11;</code>
     *
     * @return The organization.
     */
    public java.lang.String getOrganization() {
      java.lang.Object ref = organization_;
      if (!(ref instanceof java.lang.String)) {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        organization_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the organization at the address.
     * </pre>
     *
     * <code>string organization = 11;</code>
     *
     * @return The bytes for organization.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getOrganizationBytes() {
      java.lang.Object ref = organization_;
      if (ref instanceof String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        organization_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the organization at the address.
     * </pre>
     *
     * <code>string organization = 11;</code>
     *
     * @param value The organization to set.
     * @return This builder for chaining.
     */
    public Builder setOrganization(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      organization_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the organization at the address.
     * </pre>
     *
     * <code>string organization = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrganization() {
      organization_ = getDefaultInstance().getOrganization();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the organization at the address.
     * </pre>
     *
     * <code>string organization = 11;</code>
     *
     * @param value The bytes for organization to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      organization_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.type.PostalAddress)
  }

  // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.type.PostalAddress)
  private static final org.hansken.ep.shade.com.google.type.PostalAddress DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.type.PostalAddress();
  }

  public static org.hansken.ep.shade.com.google.type.PostalAddress getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.hansken.ep.shade.com.google.protobuf.Parser<PostalAddress> PARSER =
      new com.google.protobuf.AbstractParser<PostalAddress>() {
        @java.lang.Override
        public PostalAddress parsePartialFrom(
            org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
            org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static org.hansken.ep.shade.com.google.protobuf.Parser<PostalAddress> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Parser<PostalAddress> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.type.PostalAddress getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
