/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.logging;

import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class XmlConfigurationFactoryTest {
    XmlConfigurationFactoryTest() {
    }

    @Test
    void testLoadXmlConfigurationFromDefaultFile() {
        String resource = "log4j2.xml";
        URL resourceUrl = XmlConfigurationFactoryTest.class.getResource("/log4j2.xml");
        this.mockResource("log4j2.xml", resourceUrl, () -> {
            Configuration configuration = this.getConfiguration();
            Assertions.assertEquals((Object)resourceUrl.getFile(), (Object)configuration.getName());
        });
    }

    @Test
    void testLoadXmlConfigurationFromCustomFile() {
        String resource = "configuration.xml";
        URL resourceUrl = XmlConfigurationFactoryTest.class.getResource("/configuration.xml");
        System.setProperty("log4j.configurationFile", resourceUrl.getFile());
        this.mockResource("configuration.xml", resourceUrl, () -> {
            Configuration configuration = this.getConfiguration();
            Assertions.assertEquals((Object)resourceUrl.getFile(), (Object)configuration.getName());
        });
    }

    @Test
    void testLoadDefaultConfiguration() {
        this.mockResource("log4j2.xml", null, () -> {
            Configuration configuration = this.getConfiguration();
            Assertions.assertEquals((Object)"logger", (Object)configuration.getName());
        });
    }

    private Configuration getConfiguration() {
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        String loggerName = "logger";
        LoggerContext loggerContext = new LoggerContext("logger");
        return configurationFactory.getConfiguration(loggerContext, "logger", null);
    }

    private void mockResource(String resourceName, URL resource, Runnable runnable) {
        try (MockedStatic loader = Mockito.mockStatic(Loader.class);){
            loader.when(() -> Loader.getResource((String)((String)ArgumentMatchers.eq((Object)resourceName)), (ClassLoader)((ClassLoader)ArgumentMatchers.any()))).thenReturn((Object)resource);
            loader.when(Loader::getClassLoader).thenReturn((Object)XmlConfigurationFactoryTest.class.getClassLoader());
            runnable.run();
        }
    }
}

