/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.extraction.plugin.grpc.RpcSearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.SearchTraceProxy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestSearchTraceProxy {
    private static final byte[] RAW_BYTES = "these are raw bytes".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEXT_BYTES = "these are text bytes".getBytes(StandardCharsets.UTF_8);

    @Test
    public void fromRpc() throws IOException {
        GrpcFacade facade = (GrpcFacade)Mockito.mock(GrpcFacade.class);
        RpcSearchTrace rpcSearchTrace = RpcSearchTrace.newBuilder().setId("0-1").addAllData(Set.of(this.data("raw", RAW_BYTES.length, RAW_BYTES), this.data("text", TEXT_BYTES.length, TEXT_BYTES))).addAllTypes(Set.of("file", "document")).addAllProperties(Set.of(Pack.property((String)"file.name", (Object)"bluh"), Pack.property((String)"document.application", (Object)"ms-word"), Pack.property((String)"uid", (Object)"0:0-1"))).build();
        SearchTraceProxy searchTraceProxy = SearchTraceProxy.fromRpc((RpcSearchTrace)rpcSearchTrace, (GrpcFacade)facade);
        Assertions.assertEquals((Object)searchTraceProxy.types(), Set.of("file", "document"));
        Assertions.assertEquals((Object)searchTraceProxy.traceId(), (Object)"0-1");
        Assertions.assertEquals((Object)searchTraceProxy.properties(), Set.of("file.name", "document.application", "uid"));
        Assertions.assertEquals((Object)searchTraceProxy.get("file.name"), (Object)"bluh");
        MatcherAssert.assertThat((Object)searchTraceProxy.getData("raw").readNBytes(RAW_BYTES.length), (Matcher)Matchers.is((Object)RAW_BYTES));
        MatcherAssert.assertThat((Object)searchTraceProxy.getData("text").readNBytes(TEXT_BYTES.length), (Matcher)Matchers.is((Object)TEXT_BYTES));
    }

    private RpcRandomAccessDataMeta data(String type, int size, byte[] bytes) {
        return RpcRandomAccessDataMeta.newBuilder().setType(type).setSize((long)size).setFirstBytes(ByteString.copyFrom((byte[])bytes)).build();
    }
}

