/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.marshalling;

import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.buffer.ByteBuf;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.channel.ChannelHandler;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.channel.ChannelHandlerContext;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.MessageToByteEncoder;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.marshalling.MarshallerProvider;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

@ChannelHandler.Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider provider) {
        this.provider = provider;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        int lengthPos = out.writerIndex();
        out.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(out);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        out.setInt(lengthPos, out.writerIndex() - lengthPos - 4);
    }
}

