/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.util.ArgChecks;

class RandomAccessDataCache {
    private final GrpcFacade _facade;
    private final long _fileSize;
    private final int _blockSize;
    private final int _cacheSize;
    private final String _traceUid;
    private final String _type;
    private final Cache<Long, byte[]> _cache;

    RandomAccessDataCache(GrpcFacade facade, long fileSize, int blockSize, int cacheSize, String traceUid, String type) {
        this._facade = (GrpcFacade)ArgChecks.argNotNull((String)"facade", (Object)facade);
        this._fileSize = ArgChecks.argNotNegative((String)"fileSize", (long)fileSize);
        this._blockSize = ArgChecks.argNotNegative((String)"blockSize", (int)blockSize);
        this._cacheSize = ArgChecks.argNotNegative((String)"cacheSize", (int)cacheSize);
        this._traceUid = (String)ArgChecks.argNotNull((String)"_traceUid", (Object)traceUid);
        this._type = (String)ArgChecks.argNotNull((String)"type", (Object)type);
        this._cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
    }

    byte[] readFromCache(long startPosition, int count) {
        int bytesToCopy;
        ArgChecks.argNotNegative((String)"startPosition", (long)startPosition);
        ArgChecks.argNotNegative((String)"count", (int)count);
        if (count > this._cacheSize * this._blockSize) {
            return this._facade.readFromTraceData(startPosition, count, this._traceUid, this._type);
        }
        int bufferSize = Math.toIntExact(Math.min((long)count, this._fileSize - startPosition));
        byte[] buffer = new byte[bufferSize];
        for (int bytesCopied = 0; bytesCopied < count; bytesCopied += bytesToCopy) {
            long position = startPosition + (long)bytesCopied;
            int cachePosition = Math.toIntExact(position % (long)this._blockSize);
            byte[] block = this.getBlockFromCache(position);
            bytesToCopy = Math.min(this._blockSize - cachePosition, count - bytesCopied);
            if ((long)bytesToCopy + position > this._fileSize) {
                System.arraycopy(block, cachePosition, buffer, bytesCopied, Math.toIntExact(this._fileSize - position));
                break;
            }
            System.arraycopy(block, cachePosition, buffer, bytesCopied, bytesToCopy);
        }
        return buffer;
    }

    void fillCache(byte[] data) {
        int size = data.length;
        if ((long)size > this._fileSize) {
            throw new IllegalArgumentException("data contains " + size + " bytes while " + this._fileSize + " is allowed");
        }
        long bytesToRead = this._fileSize == (long)size ? (long)size : (long)(size - size % this._blockSize);
        int position = 0;
        while ((long)position < bytesToRead) {
            int blockSize = Math.min(this.calculateBlockSize(position), size - position);
            byte[] buffer = new byte[blockSize];
            System.arraycopy(data, position, buffer, 0, blockSize);
            this._cache.put((Object)position, (Object)buffer);
            position += blockSize;
        }
    }

    private byte[] getBlockFromCache(long position) {
        return (byte[])this._cache.get((Object)this.calculateCacheStartPosition(position), startPosition -> {
            int blockSize = this.calculateBlockSize((long)startPosition);
            return this._facade.readFromTraceData((long)startPosition, blockSize, this._traceUid, this._type);
        });
    }

    private int calculateBlockSize(long position) {
        return Math.toIntExact(Math.min((long)this._blockSize, this._fileSize - position));
    }

    private long calculateCacheStartPosition(long position) {
        return position - position % (long)this._blockSize;
    }
}

