/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import org.hansken.extraction.plugin.grpc.RpcDataContext;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.runtime.grpc.common.Checks;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.RandomAccessDataProxy;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class ExtractionContextProxy
implements DataContext,
AutoCloseable {
    private final String _dataType;
    private final RandomAccessData _data;

    ExtractionContextProxy(String dataType, RandomAccessData data) {
        this._dataType = (String)ArgChecks.argNotNull((String)"dataType", (Object)dataType);
        this._data = (RandomAccessData)ArgChecks.argNotNull((String)"data", (Object)data);
    }

    public static ExtractionContextProxy fromRpc(RpcDataContext context, String traceId, GrpcFacade facade) {
        ArgChecks.argNotNull((String)"context", (Object)context);
        ArgChecks.argNotNull((String)"traceId", (Object)traceId);
        ArgChecks.argNotNull((String)"facade", (Object)facade);
        return new ExtractionContextProxy(context.getDataType(), RandomAccessDataProxy.fromRpc(context.getData(), traceId, facade));
    }

    public String dataType() {
        return this._dataType;
    }

    public RandomAccessData data() {
        Checks.assertIsNotMeta((String)this.dataType());
        return this._data;
    }

    @Override
    public void close() throws Exception {
        this._data.close();
    }
}

