package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import java.util.concurrent.ExecutionException;
import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.TraceSearcher;

import static org.hansken.plugin.extraction.util.ArgChecks.argNotNull;

/**
 * Proxy implementation for the server side of the {@link ExtractionPlugin extraction plugin} framework. It
 * delegates calls through gRPC (see {@link GrpcFacade}) to retrieve traces from the client side.
 */
public class TraceSearcherProxy implements TraceSearcher {
    private final GrpcFacade _facade;

    public TraceSearcherProxy(final GrpcFacade facade) {
        _facade = argNotNull("facade", facade);
    }

    @Override
    public SearchResult search(final String query, final int count) throws InterruptedException, ExecutionException {
        return _facade.searchTraces(query, count);
    }
}
