/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.net.Socket;
import java.net.SocketException;

public class TelnetClient
implements AutoCloseable {
    private static final int EOF = -1;
    private final PrintWriter _input;
    private final BufferedReader _output;
    private final Socket _socket;
    private final PushbackReader _outputPeeker;

    public TelnetClient(int port) throws IOException {
        this._socket = new Socket("localhost", port);
        this._input = new PrintWriter(this._socket.getOutputStream(), true);
        this._output = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._outputPeeker = new PushbackReader(this._output);
    }

    public String command(String command) throws Exception {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this._input.println(command);
        return this._output.readLine();
    }

    public boolean isClosed() throws Exception {
        if (this._outputPeeker.read() == -1) {
            this._socket.close();
        }
        return this._socket.isClosed();
    }

    @Override
    public void close() throws Exception {
        this._outputPeeker.close();
        this._input.close();
        this._output.close();
        this._socket.close();
    }
}

