/*
 * Copyright 2015 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.hansken.ep.shade.io.grpc.internal;

/**
 * Determines how long to wait before doing some action (typically a retry, or a reconnect).
 */
public interface BackoffPolicy {
  interface Provider {
    BackoffPolicy get();
  }

  /**
   * Returns the number of nanoseconds to wait.
   */
  long nextBackoffNanos();
}

