/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.logging;

import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

abstract class BaseConfigurationFactory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";

    BaseConfigurationFactory() {
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationSource source;
        if (!this.isActive()) {
            return null;
        }
        if (configLocation != null && (source = ConfigurationSource.fromUri((URI)configLocation)) != null) {
            return this.getConfiguration(loggerContext, source);
        }
        Configuration configuration = this.getConfigurationFromFile(loggerContext, name);
        return configuration != null ? configuration : this.getDefaultConfiguration(name);
    }

    private Configuration getConfigurationFromFile(LoggerContext loggerContext, String name) {
        for (String type : this.getSupportedTypes()) {
            if (type.equals(ALL_TYPES)) continue;
            for (String configName : this.getConfigNames(name, type)) {
                ConfigurationSource source = ConfigurationSource.fromResource((String)configName, (ClassLoader)LoaderUtil.getThreadContextClassLoader());
                if (source == null) continue;
                return this.getConfiguration(loggerContext, source);
            }
        }
        return null;
    }

    private List<String> getConfigNames(String name, String type) {
        ArrayList<CallSite> configNames = new ArrayList<CallSite>();
        if (Strings.isNotEmpty((CharSequence)name)) {
            configNames.add((CallSite)((Object)(this.getTestPrefix() + name + type)));
            configNames.add((CallSite)((Object)(this.getDefaultPrefix() + name + type)));
        }
        configNames.add((CallSite)((Object)(this.getTestPrefix() + type)));
        configNames.add((CallSite)((Object)(this.getDefaultPrefix() + type)));
        return List.copyOf(configNames);
    }

    private Configuration getDefaultConfiguration(String name) {
        ConfigurationBuilder builder = BaseConfigurationFactory.newConfigurationBuilder();
        builder.setConfigurationName(name);
        builder.setStatusLevel(Level.ERROR);
        return (Configuration)builder.add(((AppenderComponentBuilder)builder.newAppender("stdout", "console").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT)).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%-5p|%d{yyyy-MM-dd HH:mm:ss}|%-20.20t|%-32.32c{1}|%m%n"))).add((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("stdout"))).build();
    }
}

