/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test.util;

import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class ByteArrayData
implements RandomAccessData {
    private byte[] _data;
    private long _position;

    public ByteArrayData(byte[] data) {
        this._data = (byte[])ArgChecks.argNotNull((String)"data", (Object)data);
    }

    public long size() {
        return this._data.length;
    }

    public long position() {
        this.assertOpen();
        return this._position;
    }

    public void seek(long position) {
        this.assertOpen();
        this._position = this.assertValidPosition(position);
    }

    public int read(byte[] buffer, int offset, int count) {
        this.assertOpen();
        this.assertReadParameters(buffer, offset, count);
        int shouldRead = Math.toIntExact(Math.min((long)count, this.size() - this.position()));
        System.arraycopy(this._data, (int)this.position(), buffer, offset, shouldRead);
        this.seek(this.position() + (long)shouldRead);
        return shouldRead;
    }

    public void close() {
        this._data = null;
    }

    private void assertOpen() {
        if (this._data == null) {
            throw new IllegalStateException("the data has already been closed");
        }
    }

    private long assertValidPosition(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException("the position must not be negative: " + position);
        }
        if (position > this.size()) {
            throw new IllegalArgumentException("the position must not be greater than the size of the data: " + position + " > " + this.size());
        }
        return position;
    }

    private void assertReadParameters(byte[] buffer, int offset, int count) {
        ArgChecks.argNotNegative((String)"offset", (int)offset);
        ArgChecks.argNotNegative((String)"count", (int)count);
        if (offset + count > buffer.length) {
            throw new IllegalArgumentException("offset + count is larger than the size of the buffer: offset " + offset + ", count " + count + ", buffer size " + buffer.length);
        }
    }
}

