/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hansken.plugin.extraction.api.BaseExtractionPlugin;
import org.hansken.plugin.extraction.runtime.grpc.server.ExtractionPluginServerService;
import org.hansken.plugin.extraction.runtime.grpc.server.HealthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractionPluginServer
implements AutoCloseable {
    public static final int DEFAULT_NUM_WORKERS = 12;
    private static final int MAX_MESSAGE_SIZE = 0x4000000;
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 30;
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionPluginServer.class);
    private final ExecutorService _workers;
    private volatile Server _grpcServer;

    private ExtractionPluginServer(int port, int nThreads, BindableService service) {
        this._workers = Executors.newFixedThreadPool(nThreads);
        this._grpcServer = ServerBuilder.forPort((int)port).addService((BindableService)new HealthService()).addService(service).maxInboundMessageSize(0x4000000).executor((Executor)this._workers).build();
    }

    public int getListeningPort() {
        return this._grpcServer.getPort();
    }

    @Deprecated
    public static ExtractionPluginServer serve(int port, Supplier<BaseExtractionPlugin> plugin) throws Exception {
        return ExtractionPluginServer.serve(port, 12, plugin);
    }

    public static ExtractionPluginServer serve(int port, int numberOfWorkers, Supplier<BaseExtractionPlugin> plugin) throws Exception {
        LOG.info("Starting Hansken extraction plugin on port " + port + " with " + numberOfWorkers + " workers");
        return ExtractionPluginServer.serve(new ExtractionPluginServer(port, numberOfWorkers, (BindableService)new ExtractionPluginServerService(plugin, 0x4000000)));
    }

    @Deprecated
    public static ExtractionPluginServer serve(int port, BindableService service) throws Exception {
        return ExtractionPluginServer.serve(port, 12, service);
    }

    public static ExtractionPluginServer serve(int port, int numberOfWorkers, BindableService service) throws Exception {
        LOG.info("Starting Hansken extraction plugin on port " + port);
        return ExtractionPluginServer.serve(new ExtractionPluginServer(port, numberOfWorkers, service));
    }

    public static ExtractionPluginServer serve(ExtractionPluginServer server) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                server.start();
                latch.countDown();
                server.blockUntilShutdown();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        thread.start();
        latch.await();
        int port = server.getListeningPort();
        thread.setName("grpc-extractionplugin-server@" + port);
        LOG.info("Hansken extraction plugin listening port " + port);
        return server;
    }

    @Override
    public void close() {
        if (this._grpcServer != null) {
            try {
                this._grpcServer.shutdownNow().awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Server shutdown timeout", (Throwable)e);
            }
            this._grpcServer = null;
        }
    }

    private void start() throws IOException {
        this._grpcServer.start();
    }

    void blockUntilShutdown() throws InterruptedException {
        if (this._grpcServer != null) {
            this._grpcServer.awaitTermination();
        }
    }

    ExecutorService workers() {
        return this._workers;
    }
}

