/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.RandomAccessDataCache;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class RandomAccessDataProxy
implements RandomAccessData {
    private static final int CACHE_SIZE = 10;
    private static final int BLOCK_SIZE = 104857;
    private final long _size;
    private final RandomAccessDataCache _cache;
    private long _position;
    private boolean _open;

    private RandomAccessDataProxy(RpcRandomAccessDataMeta data, String traceId, GrpcFacade facade) {
        this._size = ArgChecks.argNotNegative((String)"size", (long)data.getSize());
        this._cache = new RandomAccessDataCache(facade, this._size, 104857, 10, traceId, data.getType());
        this._open = true;
        this._cache.fillCache(data.getFirstBytes().toByteArray());
    }

    public static RandomAccessData fromRpc(RpcRandomAccessDataMeta data, String traceId, GrpcFacade facade) {
        ArgChecks.argNotNull((String)"data", (Object)data);
        ArgChecks.argNotNull((String)"traceId", (Object)traceId);
        ArgChecks.argNotNull((String)"facade", (Object)facade);
        return new RandomAccessDataProxy(data, traceId, facade);
    }

    public long size() {
        return this._size;
    }

    public long position() {
        this.assertOpen();
        return this._position;
    }

    public void seek(long position) {
        this.assertOpen();
        this._position = this.assertValidPosition(position);
    }

    public int read(byte[] buffer, int offset, int count) {
        this.assertOpen();
        this.assertReadParameters(buffer, offset, count);
        int shouldRead = Math.toIntExact(Math.min((long)count, this.size() - this.position()));
        byte[] read = this._cache.readFromCache(this.position(), shouldRead);
        int actuallyRead = read.length;
        System.arraycopy(read, 0, buffer, offset, actuallyRead);
        this.seek(this.position() + (long)actuallyRead);
        return shouldRead;
    }

    public void close() {
        this._open = false;
    }

    private void assertOpen() {
        if (!this._open) {
            throw new IllegalStateException("the data has already been closed");
        }
    }

    private long assertValidPosition(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException("the position must not be negative: " + position);
        }
        if (position > this.size()) {
            throw new IllegalArgumentException("the position must not be greater than the size of the data: " + position + " > " + this.size());
        }
        return position;
    }

    private void assertReadParameters(byte[] buffer, int offset, int count) {
        ArgChecks.argNotNegative((String)"offset", (int)offset);
        ArgChecks.argNotNegative((String)"count", (int)count);
        if (offset + count > buffer.length) {
            throw new IllegalArgumentException("offset + count is larger than the size of the buffer: offset " + offset + ", count " + count + ", buffer size " + buffer.length);
        }
    }
}

