/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.RandomAccessDataCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class RandomAccessDataCacheTest {
    private static final byte[] INPUT = "hear holistic ugliest throat industrious onerous elastic labored".getBytes(StandardCharsets.UTF_8);
    private static final List<Integer> BLOCK_SIZES = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16), Integer.valueOf(32), Integer.valueOf(64));
    private static final List<Integer> NUMBER_OF_BYTES = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(16), Integer.valueOf(32), Integer.valueOf(53), Integer.valueOf(64));
    private static final List<Integer> POSITIONS = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(16), Integer.valueOf(40), Integer.valueOf(64));

    RandomAccessDataCacheTest() {
    }

    private static Stream<Arguments> dataProvider() {
        ArrayList<Arguments> argumentsList = new ArrayList<Arguments>();
        for (int blockSize : BLOCK_SIZES) {
            for (int numberOfBytes : NUMBER_OF_BYTES) {
                for (int position : POSITIONS) {
                    int expectedLength = INPUT.length - position;
                    byte[] expected = new byte[expectedLength];
                    System.arraycopy(INPUT, position, expected, 0, expected.length);
                    argumentsList.add(Arguments.arguments((Object[])new Object[]{INPUT, position, numberOfBytes, blockSize, expected}));
                }
            }
        }
        return argumentsList.stream();
    }

    @ParameterizedTest(name="start position: {1}, count: {2}, block size: {3}")
    @MethodSource(value={"dataProvider"})
    void testReadDataWithDifferentPositions(byte[] data, int startPosition, int count, int blockSize, byte[] expected) throws IOException {
        RandomAccessDataCache cache = new RandomAccessDataCache((GrpcFacade)new TestGrpcFacade(data), (long)data.length, blockSize, 10, "0", "raw");
        byte[] actual = this.read(cache, data.length, startPosition, count);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @ParameterizedTest(name="start position: {1}, count: {2}, block size: {3}")
    @MethodSource(value={"dataProvider"})
    void testHowManyTimesReadFromTraceDataIsCalled(byte[] data, int startPosition, int count, int blockSize) {
        TestGrpcFacade facade = (TestGrpcFacade)((Object)Mockito.spy((Object)((Object)new TestGrpcFacade(data))));
        AtomicInteger numberOfInvocations = new AtomicInteger();
        Mockito.when((Object)facade.readFromTraceData(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            numberOfInvocations.incrementAndGet();
            return (byte[])invocation.callRealMethod();
        });
        RandomAccessDataCache cache = new RandomAccessDataCache((GrpcFacade)facade, (long)data.length, blockSize, 10, "0", "raw");
        this.read(cache, data.length, startPosition, count);
        Assertions.assertEquals((int)this.calculateNumberOfInvocations(data.length, blockSize, 10, startPosition, count), (int)numberOfInvocations.get());
    }

    @Test
    void testFillCacheWithAllData() {
        RandomAccessDataCache cache = new RandomAccessDataCache((GrpcFacade)new TestGrpcFacade(INPUT), (long)INPUT.length, 8, 8, "0", "raw");
        cache.fillCache(INPUT);
        Assertions.assertArrayEquals((byte[])INPUT, (byte[])cache.readFromCache(0L, INPUT.length));
    }

    @Test
    void testFillCacheWithLessBytes() {
        RandomAccessDataCache cache = new RandomAccessDataCache((GrpcFacade)new TestGrpcFacade(INPUT), (long)INPUT.length, 8, 8, "0", "raw");
        int bufferSize = 10;
        byte[] data = new byte[10];
        System.arraycopy(INPUT, 0, data, 0, 10);
        cache.fillCache(data);
        Assertions.assertArrayEquals((byte[])INPUT, (byte[])cache.readFromCache(0L, INPUT.length));
    }

    @Test
    void testReadMoreDataThanAvailable() {
        RandomAccessDataCache cache = new RandomAccessDataCache((GrpcFacade)new TestGrpcFacade(INPUT), (long)INPUT.length, 10, 10, "0", "raw");
        Assertions.assertArrayEquals((byte[])INPUT, (byte[])cache.readFromCache(0L, 100));
    }

    private byte[] read(RandomAccessDataCache cache, int size, int startPosition, int count) {
        byte[] read;
        byte[] buffer = new byte[size - startPosition];
        int bytesRead = 0;
        for (int position = startPosition; position < size; position += read.length) {
            int shouldRead = Math.min(count, size - position);
            read = cache.readFromCache((long)position, shouldRead);
            System.arraycopy(read, 0, buffer, bytesRead, read.length);
            bytesRead += read.length;
        }
        return buffer;
    }

    private int calculateNumberOfInvocations(int dataSize, int blockSize, int cacheSize, int position, int count) {
        if (count > cacheSize * blockSize) {
            int bytesToRead = dataSize - position;
            int numberOfSkippedCacheReads = bytesToRead / count;
            int bytesToReadFromCache = bytesToRead - numberOfSkippedCacheReads * count;
            if (bytesToReadFromCache > cacheSize * blockSize) {
                return numberOfSkippedCacheReads + 1;
            }
            int numberOfCacheReads = (bytesToReadFromCache + blockSize - 1) / blockSize;
            return numberOfSkippedCacheReads + numberOfCacheReads;
        }
        return (dataSize - position + blockSize - 1) / blockSize;
    }

    private static final class TestGrpcFacade
    extends GrpcFacade {
        private final byte[] _testData;

        TestGrpcFacade(byte[] testData) {
            super(new ArrayBlockingQueue(1), (StreamObserver)Mockito.mock(StreamObserver.class), 0x100000);
            this._testData = testData;
        }

        public byte[] readFromTraceData(long position, int count, String traceId, String type) {
            byte[] buffer = new byte[count];
            System.arraycopy(this._testData, Math.toIntExact(position), buffer, 0, count);
            return buffer;
        }
    }
}

