/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.extraction.plugin.grpc.RpcSearchResult;
import org.hansken.extraction.plugin.grpc.RpcSearchTrace;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchScope;
import org.hansken.plugin.extraction.api.SearchSortOption;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.SearchTraceProxy;

class BatchedSearchResult
implements SearchResult {
    private static final int NOT_KNOWN_YET = -1;
    private static final int MAX_BATCH_SIZE = 50;
    private static final int ELASTICSEARCH_INDEX_LIMIT = 100000;
    private final GrpcFacade _grpcFacade;
    private final String _query;
    private final int _count;
    private final SearchScope _scope;
    private final int _start;
    private final List<SearchSortOption> _sort;
    private BatchedSearchTraceSpliterator _spliterator;
    private long _totalResults;

    BatchedSearchResult(GrpcFacade grpcFacade, String query, int count, SearchScope scope, int start, List<SearchSortOption> sort) {
        this._grpcFacade = grpcFacade;
        this._query = query;
        this._count = count;
        this._scope = scope;
        this._start = start;
        this._sort = sort;
        this._totalResults = -1L;
        this._spliterator = new BatchedSearchTraceSpliterator(this._start);
        this._spliterator.initializeTotalResults();
    }

    public Stream<SearchTrace> getTraces() {
        if (this._spliterator.hasAdvanced()) {
            this._spliterator = new BatchedSearchTraceSpliterator(this._start);
        }
        return StreamSupport.stream(this._spliterator, false);
    }

    public long getTotalHits() {
        return this._totalResults;
    }

    private class BatchedSearchTraceSpliterator
    extends Spliterators.AbstractSpliterator<SearchTrace> {
        private int _position;
        private int _currentCount;
        private Deque<RpcSearchTrace> _currentBatch;

        BatchedSearchTraceSpliterator(int start) {
            super(Long.MAX_VALUE, 1297);
            this._position = start;
            this._currentCount = 0;
            this._currentBatch = new ArrayDeque<RpcSearchTrace>();
        }

        @Override
        public boolean tryAdvance(Consumer<? super SearchTrace> action) {
            boolean hasRemainingTraces;
            if (this._position > 100000) {
                throw new IllegalStateException("Search request offset must not exceed the Elasticsearch limit of 100.000.");
            }
            boolean countNotReached = BatchedSearchResult.this._count == -1 || this._currentCount < BatchedSearchResult.this._count;
            boolean bl = hasRemainingTraces = (long)this._position < BatchedSearchResult.this._totalResults;
            if (countNotReached && this._currentBatch.isEmpty() && hasRemainingTraces) {
                this.prepareNextBatch();
            }
            if (!this._currentBatch.isEmpty()) {
                action.accept(SearchTraceProxy.fromRpc(this._currentBatch.pop(), BatchedSearchResult.this._grpcFacade));
                ++this._position;
                ++this._currentCount;
                return true;
            }
            return false;
        }

        private void prepareNextBatch() {
            Any anyResult = BatchedSearchResult.this._grpcFacade.call(Pack.searchRequest((String)BatchedSearchResult.this._query, (int)this.getNumberOfResultsToGet(), (SearchScope)BatchedSearchResult.this._scope, (int)this._position, BatchedSearchResult.this._sort));
            RpcSearchResult rpcResult = (RpcSearchResult)Unpack.any((Any)anyResult, RpcSearchResult.class);
            if (BatchedSearchResult.this._totalResults == -1L) {
                BatchedSearchResult.this._totalResults = rpcResult.getTotalResults();
            }
            this._currentBatch = new ArrayDeque<RpcSearchTrace>(rpcResult.getTracesList());
        }

        private int getNumberOfResultsToGet() {
            if (BatchedSearchResult.this._totalResults == -1L) {
                return this.getFirstBatchSize();
            }
            return this.getSubsequentBatchSize();
        }

        private int getFirstBatchSize() {
            if (BatchedSearchResult.this._count != -1 && BatchedSearchResult.this._count < 50) {
                return BatchedSearchResult.this._count;
            }
            return 50;
        }

        private int getSubsequentBatchSize() {
            long remaining = this.getRemaining();
            if (remaining > 50L) {
                return 50;
            }
            return Math.toIntExact(remaining);
        }

        private long getRemaining() {
            long totalToGet = BatchedSearchResult.this._count != -1 ? (long)BatchedSearchResult.this._count : BatchedSearchResult.this._totalResults;
            return totalToGet - (long)this._currentCount;
        }

        private void initializeTotalResults() {
            this.prepareNextBatch();
        }

        public boolean hasAdvanced() {
            return this._currentCount > 0;
        }
    }
}

