/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTraceProperty;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.ImmutableTraceProxy;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.OutputStreamProxy;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.hansken.plugin.extraction.util.ThrowingConsumer;

public final class TraceProxy
extends ImmutableTraceProxy
implements Trace,
AutoCloseable {
    private final Set<String> _types;
    private final Map<String, Object> _properties;
    private final String _id;
    private final GrpcFacade _facade;
    private final Set<String> _newTypes;
    private final Map<String, Object> _newProperties;
    private final List<Trace.Tracelet> _newTracelets;
    private final Map<String, List<DataTransformation>> _transformations;
    private boolean _open;
    private long _nextChild;

    private TraceProxy(String id, Set<String> types, Map<String, Object> properties, GrpcFacade facade) {
        super(types, properties, id);
        this._id = (String)ArgChecks.argNotNull((String)"id", (Object)id);
        this._types = new HashSet<String>((Collection)ArgChecks.argNotNull((String)"types", types));
        this._properties = new HashMap<String, Object>((Map)ArgChecks.argNotNull((String)"properties", properties));
        this._newTypes = new HashSet<String>();
        this._newProperties = new HashMap<String, Object>();
        this._newTracelets = new ArrayList<Trace.Tracelet>();
        this._transformations = new HashMap<String, List<DataTransformation>>();
        this._facade = (GrpcFacade)ArgChecks.argNotNull((String)"facade", (Object)facade);
        this._open = true;
    }

    public static TraceProxy fromRpc(RpcTrace trace, GrpcFacade facade) {
        ArgChecks.argNotNull((String)"trace", (Object)trace);
        ArgChecks.argNotNull((String)"facade", (Object)facade);
        HashSet<String> types = new HashSet<String>(trace.getTypesList());
        Map<String, Object> properties = TraceProxy.getProperties(trace.getPropertiesList());
        return new TraceProxy(trace.getId(), types, properties, facade);
    }

    static Map<String, Object> getProperties(List<RpcTraceProperty> properties) {
        return properties.stream().collect(Collectors.toMap(RpcTraceProperty::getName, property -> Unpack.primitive((Any)property.getValue())));
    }

    @Override
    public Set<String> types() {
        this.assertOpen();
        return this._types;
    }

    public Trace addType(String type) {
        this.assertOpen();
        this._types.add(ArgChecks.argNotEmpty((String)"type", (String)type));
        this._newTypes.add(type);
        return this;
    }

    @Override
    public Set<String> properties() {
        this.assertOpen();
        return this._properties.keySet();
    }

    @Override
    public <T> T get(String name) {
        this.assertOpen();
        return (T)this._properties.get(ArgChecks.argNotEmpty((String)"name", (String)name));
    }

    public Trace set(String name, Object value) {
        this.assertOpen();
        this._properties.put(ArgChecks.argNotEmpty((String)"name", (String)name), value);
        this._newProperties.put(name, value);
        return this;
    }

    public Trace addTracelet(Trace.Tracelet tracelet) {
        this._newTracelets.add(tracelet);
        return this;
    }

    public List<Trace.Tracelet> getNewTracelets() {
        return this._newTracelets;
    }

    public Trace setData(String dataType, DataWriter writer) throws IOException {
        try (OutputStreamProxy stream = new OutputStreamProxy(this._id, dataType, this._facade);){
            writer.writeTo((OutputStream)stream);
        }
        return this;
    }

    public Trace setData(String dataType, List<DataTransformation> transformations) {
        ArgChecks.argNotEmpty((String)"dataType", (String)dataType);
        ArgChecks.argNotEmpty((String)"transformations", transformations);
        this._transformations.put(dataType, transformations);
        return this;
    }

    public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) throws IOException {
        this.assertOpen();
        String id = this.incrementAndGetNextId();
        this._facade.beginChild(id, name);
        try (TraceProxy child = new TraceProxy(id, Collections.emptySet(), Collections.emptyMap(), this._facade);){
            child.set("name", name);
            enrichChildCallback.accept((Object)child);
        }
        return this;
    }

    @Override
    public void close() {
        if (!this._open) {
            return;
        }
        this.flush();
        if (!"0".equals(this._id)) {
            this._facade.finishChild(this._id);
        }
        this._open = false;
    }

    void flush() {
        if (this._newTypes.isEmpty() && this._newProperties.isEmpty() && this._newTracelets.isEmpty() && this._transformations.isEmpty()) {
            return;
        }
        this._newProperties.remove("name");
        this._facade.enrichTrace(this._id, this._newTypes, this._newProperties, this._newTracelets, this._transformations);
        this._newTypes.clear();
        this._newProperties.clear();
    }

    private void assertOpen() {
        if (!this._open) {
            throw new IllegalStateException("the trace proxy has already been closed");
        }
    }

    private String incrementAndGetNextId() {
        return this._id + "-" + this._nextChild++;
    }
}

